package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.repository.CategoryRepository;
import com.imcode.imcms.addon.imagearchive.service.CategoryService;
import com.imcode.imcms.addon.imagearchive.service.exception.CategoryExistsException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class CategoryServiceImpl implements CategoryService {
    @Autowired
    private CategoryRepository repository;
//    @Qualifier("hibernateTemplate")
//    private HibernateTemplate template;


//    @SuppressWarnings("unchecked")
//    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
//    public List<CategoryTypes> getCategoryTypes() {
//        return (List<CategoryTypes>) template.executeFind(new HibernateCallback() {
//
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                List<CategoryTypes> types = session.createQuery(
//                        "SELECT ct.id AS id, ct.name AS name FROM CategoryTypes ct WHERE ct.imageArchive IS TRUE ORDER BY ct.name")
//                        .setResultTransformer(Transformers.aliasToBean(CategoryTypes.class))
//                        .list();
//
//                return types;
//            }
//        });
//    }
//
//    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
//    public List<CategoryRoles> findCategoryRoles(final Roles role) {
//        return (List<CategoryRoles>) template.executeFind(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                return session.createQuery("SELECT cr.categoryId AS categoryId, cr.roleId AS roleId, cr.canUse AS canUse, cr.canChange AS canChange " +
//                        "FROM CategoryRoles cr WHERE cr.roleId = :roleId")
//                        .setInteger("roleId", role.getId())
//                        .setResultTransformer(Transformers.aliasToBean(CategoryRoles.class))
//                        .list();
//            }
//        });
//    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public boolean existsCategory(final String categoryName) {
        return repository.findByName(categoryName) != null;
    }

//    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
//    public boolean existsCategory(final String categoryName) {
//        return (Boolean) template.execute(new HibernateCallback() {
//
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                return ((Number) session.createCriteria(Category.class, "c")
//                        .createAlias("c.type", "t")
//                        .add(Restrictions.sqlRestriction("{alias}.name COLLATE utf8_bin = ?", categoryName, Hibernate.STRING))
//                        .setProjection(Projections.rowCount())
//                        .list().get(0)).longValue() > 0L;
//            }
//        });
//    }

//    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
//    public boolean existsCategory(final int categoryId, final String newCategoryName) {
//        return (Boolean) template.execute(new HibernateCallback() {
//
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                return ((Number) session.createCriteria(Category.class, "c")
//                        .createAlias("c.type", "t")
//                        .add(Restrictions.sqlRestriction("{alias}.name COLLATE utf8_bin = ?", newCategoryName, Hibernate.STRING))
//                        .add(Restrictions.ne("c.id", categoryId))
//                        .add(Restrictions.eq("t.imageArchive", true))
//                        .setProjection(Projections.rowCount())
//                        .list().get(0)).longValue() > 0L;
//            }
//        });
//    }

    public Category createCategory(final String categoryName) throws CategoryExistsException {
        if (repository.findByName(categoryName) != null) {
            throw new CategoryExistsException();
        }

        Category category = new Category(categoryName);

        return repository.save(category);
    }

//    public Category createCategory(final String categoryName) throws CategoryExistsException {
//
//        return (Category) template.execute(new HibernateCallback() {
//
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
////                Integer typeId = (Integer) session.createQuery("SELECT ct.id FROM CategoryTypes ct WHERE ct.id = :id")
////                        .setInteger("id", categoryTypeId)
////                        .uniqueResult();
////
////                if (typeId == null) {
////                    return null;
////                }
//
//                if (existsCategory(categoryName)) {
//                    throw new CategoryExistsException();
//                }
//
//                Category category = new Category();
//                category.setName(categoryName);
////                category.setTypeId(categoryTypeId);
////                category.setDescription("");
////                category.setImage("");
//
//                session.persist(category);
//                session.flush();
//
//                return category;
//            }
//        });
//    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public Category getCategory(final Long categoryId) {
        return repository.findOne(categoryId);
    }

    @SuppressWarnings("unchecked")
    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public List<Category> getCategories() {
        return repository.findAll();
    }

    public void deleteCategory(final Long categoryId) {
        repository.delete(categoryId);
    }

    public void updateCategory(final Long categoryId, final String categoryName) throws CategoryExistsException {
        Category existsCategory = repository.findOne(categoryId);

        if (existsCategory != null && repository.findByName(categoryName) == null) {
            existsCategory.setName(categoryName);
            repository.save(existsCategory);
        }
    }
}
