package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.SessionConstants;
//import com.imcode.imcms.addon.imagearchive.entity.Users;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Locale;

public class AccessFilter implements Filter {
    private static final Log log = LogFactory.getLog(AccessFilter.class);
    
    private FilterConfig filterConfig = null;
    private Facade facade;
    
    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext(filterConfig.getServletContext());
        this.filterConfig = filterConfig;
        this.facade = context.getBean(Facade.class);
    }
    
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        fixUTF8(request, response);

        HttpServletRequest httpRequest = (HttpServletRequest) request;
        HttpServletResponse httpResponse = (HttpServletResponse) response;

        setLocale(httpRequest, httpResponse);
        setRequestUrl(httpRequest);

        chain.doFilter(httpRequest, httpResponse);
    }
    
    private void setLocale(HttpServletRequest request, HttpServletResponse response) {
		log.debug("Looking for locale...");
        HttpSession session = request.getSession();
        Locale locale = (Locale) session.getAttribute(SessionConstants.LOCALE);
        if (locale != null) {
			log.debug("Using locale " + locale.getDisplayLanguage());
            return;
        }
        
        BidiMap languages = facade.getConfig().getLanguages();
        
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName().equals("im_lang")) {
                    if (languages.containsValue(cookie.getValue())) {
                        locale = new Locale(cookie.getValue());
                    }
                    break;
                }
            }
        }
        
        if (locale == null) {
            String lang = "sv";
			locale = new Locale(lang);
		}

		log.debug("Using locale " + locale.getDisplayLanguage());
		session.setAttribute(SessionConstants.LOCALE, locale);
        session.setAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME, locale);
        request.setAttribute("locale", locale);
    }
    
    private void setRequestUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        String queryString = request.getQueryString();
        
        if (queryString != null) {
            url += "?" + queryString;
        }
        
        request.setAttribute("requestUrl", url);
    }
    
    private void fixUTF8(ServletRequest request, ServletResponse response) throws IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
    }
    
    public void destroy() {
    }
}
