/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import com.imcode.imcms.addon.imagearchive.dto.LibraryRolesDto;
import com.imcode.imcms.addon.imagearchive.entity.Library;
import com.imcode.imcms.addon.imagearchive.repository.LibraryRepository;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.LibraryService;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LibraryServiceImpl
implements LibraryService {
    @Autowired
    private Facade facade;
    @Autowired
    private LibraryRepository libraryRepository;

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Library findLibraryById(Long libraryId) {
        return (Library)this.libraryRepository.findOne(libraryId);
    }

    public void syncLibraryFolders() {
        this.syncOldLibraryFolders((short)1);
        this.syncOldLibraryFolders((short)0);
    }

    private void syncOldLibraryFolders(short typeOldLibrary) {
        String folderNm;
        Object[] oldLibraryFiles = this.facade.getConfig().getImcmsOldLibraryPaths();
        HashSet files = new HashSet();
        for (File file : oldLibraryFiles) {
            List tmp = this.facade.getFileService().getSubdirs(file, new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String name = file.getName();
                    return file.isDirectory() && name.length() <= 255;
                }
            });
            files.addAll(tmp);
        }
        CollectionUtils.addAll(files, (Object[])oldLibraryFiles);
        if (files.isEmpty()) {
            this.libraryRepository.deleteByLibraryType(typeOldLibrary);
        }
        List<Library> existingLibraries = this.libraryRepository.findByLibraryType(typeOldLibrary);
        LinkedList<Library> toDelete = new LinkedList<Library>();
        for (Library library : existingLibraries) {
            folderNm = library.getFolderNm();
            String filepath = library.getFilepath();
            File file = new File(filepath, folderNm);
            if (!files.contains(file)) {
                toDelete.add(library);
                continue;
            }
            files.remove(file);
        }
        if (!toDelete.isEmpty()) {
            this.libraryRepository.delete(toDelete);
        }
        for (File file : files) {
            folderNm = file.getName();
            Library lib = new Library();
            lib.setFolderNm(folderNm);
            lib.setLibraryNm(StringUtils.substring((String)folderNm, (int)0, (int)120));
            lib.setFilepath(file.getParent());
            lib.setLibraryType(typeOldLibrary);
            this.libraryRepository.save(lib);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Library> findLibraries() {
        return this.libraryRepository.findAll();
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<LibraryRolesDto> findLibraryRoles(Long libraryId) {
        return Collections.emptyList();
    }

    public void updateLibraryRoles(int libraryId, String libraryNm, List<LibraryRolesDto> libraryRoles) {
    }

    public List<LibrariesDto> libruariesToDto(List<Library> libraries) {
        LinkedList<LibrariesDto> librariesDtos = new LinkedList<LibrariesDto>();
        for (Library library : libraries) {
            LibrariesDto librariesDto = this.convertToLibruaryDto(library);
            librariesDtos.add(librariesDto);
        }
        return librariesDtos;
    }

    public LibrariesDto convertToLibruaryDto(Library library) {
        LibrariesDto librariesDto = new LibrariesDto();
        librariesDto.setId(library.getId());
        librariesDto.setLibraryNm(library.getLibraryNm());
        librariesDto.setFilepath(library.getFilepath());
        librariesDto.setFolderNm(library.getFolderNm());
        return librariesDto;
    }

    public LibrariesDto findLibruaryDtoById(Long id) {
        return this.convertToLibruaryDto((Library)this.libraryRepository.findOne(id));
    }

    public List<LibrariesDto> findLibruaryDtos() {
        return this.libruariesToDto(this.libraryRepository.findAll());
    }
}

