package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import com.imcode.imcms.addon.imagearchive.dto.LibraryRolesDto;
import com.imcode.imcms.addon.imagearchive.entity.Library;
import com.imcode.imcms.addon.imagearchive.repository.LibraryRepository;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.LibraryService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.FileFilter;
import java.util.*;

//import com.imcode.imcms.addon.imagearchive.entity.LibraryRoles;
//import com.imcode.imcms.addon.imagearchive.entity.Roles;
//import com.imcode.imcms.addon.imagearchive.entity.Users;

@Service
@Transactional
public class LibraryServiceImpl implements LibraryService {
    @Autowired
    private Facade facade;

    @Autowired
    private LibraryRepository libraryRepository;


    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public Library findLibraryById(final Long libraryId) {
        return libraryRepository.findOne(libraryId);
//        return (Library) template.execute(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                return session.createQuery(
//                        "SELECT lib.id AS id, lib.folderNm AS folderNm, lib.libraryNm AS libraryNm, " +
//                        "lib.filepath AS filepath, lib.libraryType AS libraryType " +
//                        "FROM Libraries lib WHERE lib.id = :libraryId")
//                        .setInteger("libraryId", libraryId)
//                        .setResultTransformer(Transformers.aliasToBean(Library.class))
//                        .uniqueResult();
//            }
//        });
    }

    public void syncLibraryFolders() {
        syncOldLibraryFolders(Library.TYPE_OLD_LIBRARY);
        syncOldLibraryFolders(Library.TYPE_STANDARD);

//        template.execute(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                syncOldLibraryFolders(session);
//
//                List<File> folders = facade.getFileService().listLibraryFolders();
//
//                if (folders.isEmpty()) {
//                    session.getNamedQuery("deleteLibraryRoles")
//                            .setShort("type", Library.TYPE_STANDARD)
//                            .executeUpdate();
//                    session.getNamedQuery("deleteLibraries")
//                            .setShort("type", Library.TYPE_STANDARD)
//                            .executeUpdate();
//
//                    return null;
//                }
//
//                List<Library> existingLibraries = session.createQuery(
//                        "SELECT lib.id AS id, lib.folderNm AS folderNm, lib.filepath as filepath FROM Libraries lib WHERE lib.libraryType = :typeStandard")
//                        .setShort("typeStandard", Library.TYPE_STANDARD)
//                        .setResultTransformer(Transformers.aliasToBean(Library.class))
//                        .list();
//
//                List<Integer> toDelete = new ArrayList<Integer>();
//
//                for (Library lib : existingLibraries) {
//                    File libraryFolder = new File(lib.getFilepath(), lib.getFolderNm());
//
//                    if (!folders.contains(libraryFolder)) {
//                        toDelete.add(lib.getId());
//                    } else {
//                        folders.remove(libraryFolder);
//                    }
//                }
//
//                if (!toDelete.isEmpty()) {
//                    session.createQuery(
//                            "DELETE FROM LibraryRoles lr WHERE lr.libraryId IN (:libraryIds) ")
//                            .setParameterList("libraryIds", toDelete)
//                            .executeUpdate();
//
//                    session.createQuery("DELETE FROM Libraries lib WHERE lib.id IN (:libraryIds) ")
//                            .setParameterList("libraryIds", toDelete)
//                            .executeUpdate();
//                }
//
//                for (File folder : folders) {
//                    Library lib = new Library();
//                    lib.setFolderNm(folder.getName());
//                    lib.setLibraryNm(StringUtils.substring(folder.getName(), 0, 120));
//                    lib.setLibraryType(Library.TYPE_STANDARD);
//                    lib.setFilepath(folder.getParent());
//
//                    session.persist(lib);
//                }
//                session.flush();
//
//                return null;
//            }
//        });
    }

    private void syncOldLibraryFolders(short typeOldLibrary) {
        File[] oldLibraryFiles = facade.getConfig().getImcmsOldLibraryPaths();
        Set<File> files = new HashSet<File>();
        for (File f : oldLibraryFiles) {
            List<File> tmp = facade.getFileService().getSubdirs(f, new FileFilter() {
                public boolean accept(File file) {
                    String name = file.getName();

                    return file.isDirectory() && name.length() <= 255;
                }
            });

            files.addAll(tmp);
        }

        CollectionUtils.addAll(files, oldLibraryFiles);

//        short typeOldLibrary = Library.TYPE_OLD_LIBRARY;
        if (files.isEmpty()) {
            libraryRepository.deleteByLibraryType(typeOldLibrary);
        }

        List<Library> existingLibraries = libraryRepository.findByLibraryType(typeOldLibrary);

        List<Library> toDelete = new LinkedList<Library>();

        for (Library lib : existingLibraries) {
            String folderNm = lib.getFolderNm();
            String filepath = lib.getFilepath();
            File file = new File(filepath, folderNm);

            if (!files.contains(file)) {
                toDelete.add(lib);
            } else {
                files.remove(file);
            }
        }

        if (!toDelete.isEmpty()) {
            libraryRepository.delete(toDelete);
        }

        for (File file : files) {
            String folderNm = file.getName();

            Library lib = new Library();
            lib.setFolderNm(folderNm);
            lib.setLibraryNm(StringUtils.substring(folderNm, 0, 120));
            lib.setFilepath(file.getParent());
            lib.setLibraryType(typeOldLibrary);

            libraryRepository.save(lib);
        }
////////////////////////////////////////////////////////////////////////////////////////////////////
//       File[] oldLibraryFiles = facade.getConfig().getImcmsOldLibraryPaths();
//        Set<File> files = new HashSet<File>();
//        for(File f: oldLibraryFiles) {
//            List<File> tmp = facade.getFileService().getSubdirs(f, new FileFilter() {
//                public boolean accept(File file) {
//                    String name = file.getName();
//
//                    return file.isDirectory() && name.length() <= 255;
//                }
//            });
//
//            files.addAll(tmp);
//        }
//
//        CollectionUtils.addAll(files, oldLibraryFiles);
//
//        if (files.isEmpty()) {
//            session.getNamedQuery("deleteLibraryRoles")
//                    .setShort("type", Library.TYPE_OLD_LIBRARY)
//                    .executeUpdate();
//            session.getNamedQuery("deleteLibraries")
//                    .setShort("type", Library.TYPE_OLD_LIBRARY)
//                    .executeUpdate();
//        }
//
//        List<Library> existingLibraries = session.createQuery(
//                "SELECT lib.id AS id, lib.folderNm AS folderNm, lib.filepath AS filepath " +
//                "FROM Libraries lib WHERE lib.libraryType = :typeOld")
//                .setShort("typeOld", Library.TYPE_OLD_LIBRARY)
//                .setResultTransformer(Transformers.aliasToBean(Library.class))
//                .list();
//
//        List<Integer> toDelete = new ArrayList<Integer>();
//
//        for (Library lib : existingLibraries) {
//            String folderNm = lib.getFolderNm();
//            String filepath = lib.getFilepath();
//            File file = new File(filepath, folderNm);
//
//            if (!files.contains(file)) {
//                toDelete.add(lib.getId());
//            } else {
//                files.remove(file);
//            }
//        }
//
//        if (!toDelete.isEmpty()) {
//            session.createQuery(
//                    "DELETE LibraryRoles lr WHERE lr.libraryId IN (:libraryIds) ")
//                    .setParameterList("libraryIds", toDelete)
//                    .executeUpdate();
//
//            session.createQuery(
//                    "DELETE Libraries lib WHERE lib.id IN (:libraryIds) ")
//                    .setParameterList("libraryIds", toDelete)
//                    .executeUpdate();
//        }
//
//        for (File file : files) {
//            String folderNm = file.getName();
//
//            Library lib = new Library();
//            lib.setFolderNm(folderNm);
//            lib.setLibraryNm(StringUtils.substring(folderNm, 0, 120));
//            lib.setFilepath(file.getParent());
//            lib.setLibraryType(Library.TYPE_OLD_LIBRARY);
//
//            session.persist(lib);
//        }
//        session.flush();
    }

    @SuppressWarnings("unchecked")
    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public List<Library> findLibraries() {
        return libraryRepository.findAll();
//        return (List<Library>) template.executeFind(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                return session.createQuery(
//                        "SELECT lib.id AS id, lib.folderNm AS folderNm, lib.libraryNm AS libraryNm, " +
//                        "lib.filepath AS filepath, lib.libraryType AS libraryType FROM Libraries lib " +
//                        "ORDER BY lib.folderNm")
//                        .setResultTransformer(Transformers.aliasToBean(Library.class))
//                        .list();
//            }
//        });
    }

//    @SuppressWarnings("unchecked")
//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public List<Roles> findAvailableRoles(final Long libraryId) {
//        return new ArrayList<Roles>();
////        return (List<Roles>) template.executeFind(new HibernateCallback() {
////            public Object doInHibernate(Session session) throws HibernateException, SQLException {
////                return session.createQuery(
////                        "SELECT r.id AS id, r.roleName AS roleName FROM Roles r " +
////                        "WHERE NOT EXISTS (FROM LibraryRoles lr WHERE lr.roleId = r.id AND lr.libraryId = :libraryId) " +
////                        "ORDER BY r.roleName")
////                        .setInteger("libraryId", libraryId)
////                        .setResultTransformer(Transformers.aliasToBean(Roles.class))
////                        .list();
////            }
////        });
//    }

//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public List<Roles> findRoles() {
//        return findAvailableRoles(0L);
////        return (List<Roles>) template.executeFind(new HibernateCallback() {
////            public Object doInHibernate(Session session) throws HibernateException, SQLException {
////                return session.createQuery(
////                        "SELECT r.id AS id, r.roleName AS roleName FROM Roles r " +
////                                "ORDER BY r.roleName")
////                        .setResultTransformer(Transformers.aliasToBean(Roles.class))
////                        .list();
////            }
////        });
//    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public List<LibraryRolesDto> findLibraryRoles(final Long libraryId) {
//        Library library = findLibraryById(libraryId);
//        LibrariesDto librariesDto = convertToLibruaryDto(library);
        return Collections.emptyList();
//        return (List<LibraryRolesDto>) template.executeFind(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                return session.getNamedQuery("libraryRoles")
//                        .setInteger("libraryId", libraryId)
//                        .setResultTransformer(Transformers.aliasToBean(LibraryRolesDto.class))
//                        .list();
//            }
//        });
    }

    public void updateLibraryRoles(final int libraryId, final String libraryNm,
                                   final List<LibraryRolesDto> libraryRoles) {
//        template.execute(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                session.createQuery(
//                "UPDATE Libraries lib SET lib.libraryNm = :libraryNm, lib.updatedDt = current_timestamp() WHERE lib.id = :libraryId")
//                .setString("libraryNm", libraryNm)
//                .setInteger("libraryId", libraryId)
//                .executeUpdate();
//
//
//                /* applying the same permissions to this library's sub libraries */
//                Library library = findLibraryById(libraryId);
//                List<Library> allLibraries = findLibraries();
//
//                List<Integer> idsOfSubLibraries = Utils.getLibrarySubLibriesIds(library, allLibraries);
//                List<Integer> libraryTreeIds = new ArrayList<Integer>();
//                libraryTreeIds.add(library.getId());
//                for(Integer subLibId: idsOfSubLibraries) {
//                    libraryTreeIds.add(subLibId);
//                }
//
//                if (libraryRoles.isEmpty()) {
//                    session.createQuery(
//                            "DELETE FROM LibraryRoles lr WHERE lr.libraryId IN (:libraryIds)")
//                            .setParameterList("libraryIds", libraryTreeIds)
//                            .executeUpdate();
//
//                    return null;
//                }
//
//                Map<Integer, LibraryRolesDto> roleMap = new HashMap<Integer, LibraryRolesDto>(libraryRoles.size());
//                for (LibraryRolesDto libraryRole : libraryRoles) {
//                    roleMap.put(libraryRole.getRoleId(), libraryRole);
//                }
//
//                List<Integer> existingRoleIds = session.createQuery(
//                        "SELECT lr.roleId FROM LibraryRoles lr WHERE lr.libraryId IN (:libraryIds)")
//                        .setParameterList("libraryIds", libraryTreeIds)
//                        .list();
//
//                if(existingRoleIds == null) {
//                    existingRoleIds = new ArrayList<Integer>();
//                }
//
//                /* removing role id duplicates */
//                Set<Integer> setOfExistingRoleIds = new LinkedHashSet<Integer>(existingRoleIds);
//
//                List<Integer> toDelete = new ArrayList<Integer>();
//                List<LibraryRolesDto> toUpdate = new ArrayList<LibraryRolesDto>();
//                for (Integer roleId : setOfExistingRoleIds) {
//                    if (roleMap.containsKey(roleId)) {
//                        toUpdate.add(roleMap.get(roleId));
//                        roleMap.remove(roleId);
//                    } else {
//                        toDelete.add(roleId);
//                    }
//                }
//
//                if (!toDelete.isEmpty()) {
//                    session.createQuery("DELETE FROM LibraryRoles lr WHERE lr.libraryId IN (:libraryIds) AND lr.roleId IN (:roleIds)")
//                            .setParameterList("libraryIds", libraryTreeIds)
//                            .setParameterList("roleIds", toDelete)
//                            .executeUpdate();
//                }
//
//
//                Collection<LibraryRolesDto> toCreate = roleMap.values();
//                for(Integer libId: libraryTreeIds) {
//                    for (LibraryRolesDto libraryRoleDto : toCreate) {
//                        LibraryRoles libraryRole = new LibraryRoles();
//                        libraryRole.setLibraryId(libId);
//                        libraryRole.setRoleId(libraryRoleDto.getRoleId());
//                        libraryRole.setCanUse(libraryRoleDto.isCanUse());
//                        libraryRole.setCanChange(libraryRoleDto.isCanChange());
//
//                        session.persist(libraryRole);
//                    }
//                }
//
//                Query updateQuery = session.createQuery(
//                        "UPDATE LibraryRoles lr SET lr.canUse = :canUse, lr.canChange = :canChange, lr.updatedDt = current_timestamp() " +
//                        "WHERE lr.libraryId IN (:libraryIds) AND lr.roleId = :roleId")
//                        .setParameterList("libraryIds", libraryTreeIds);
//                for (LibraryRolesDto libraryRoleDto : toUpdate) {
//                    updateQuery.setInteger("roleId", libraryRoleDto.getRoleId())
//                            .setBoolean("canUse", libraryRoleDto.isCanUse())
//                            .setBoolean("canChange", libraryRoleDto.isCanChange())
//                            .executeUpdate();
//                }
//
//                session.flush();
//
//                return null;
//            }
//        });
    }

    @Override
    public List<LibrariesDto> libruariesToDto(List<Library> libraries) {
        List<LibrariesDto> librariesDtos = new LinkedList<LibrariesDto>();

        for (Library library : libraries) {
            LibrariesDto librariesDto = convertToLibruaryDto(library);
            librariesDtos.add(librariesDto);
        }

        return librariesDtos;
    }

//    @SuppressWarnings("unchecked")
//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public List<LibrariesDto> findLibraries() {
//        List<Library> libraries = libraryRepository.findAll();
//        List<LibrariesDto> librariesDtos = new LinkedList<LibrariesDto>();
//
//        for (Library library : libraries) {
//            LibrariesDto librariesDto = convertToLibruaryDto(library);
//            librariesDtos.add(librariesDto);
//        }
//
//        return librariesDtos;

//        return (List<LibrariesDto>) template.executeFind(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                if (user.isSuperadmin() || Utils.isImageAdmin(user, facade)) {
//                    return session.createQuery(
//                            "SELECT lib.id AS id, lib.libraryNm AS libraryNm, lib.filepath AS filepath, lib.folderNm AS folderNm" +
//                                    " FROM Libraries lib ORDER BY lib.libraryNm")
//                            .setResultTransformer(Transformers.aliasToBean(LibrariesDto.class))
//                            .list();
//                }
//
//                List<Integer> roleIds = user.getRoleIds();
//                if (roleIds.isEmpty()) {
//                    return Collections.EMPTY_LIST;
//                }
//
//                return session.createQuery(
//                        "SELECT DISTINCT lib.id AS id, lib.libraryNm AS libraryNm, lib.filepath AS filepath, lib.folderNm AS folderNm" +
//                                " FROM LibraryRoles lr INNER JOIN lr.library lib " +
//                                "WHERE lr.roleId IN (:roleIds) ORDER BY lib.libraryNm ")
//                        .setParameterList("roleIds", roleIds)
//                        .setResultTransformer(Transformers.aliasToBean(LibrariesDto.class))
//                        .list();
//            }
//        });
//    }

    public LibrariesDto convertToLibruaryDto(Library library) {
        LibrariesDto librariesDto = new LibrariesDto();
        librariesDto.setId(library.getId());
        librariesDto.setLibraryNm(library.getLibraryNm());
        librariesDto.setFilepath(library.getFilepath());
        librariesDto.setFolderNm(library.getFolderNm());

        return librariesDto;
    }

    @Override
    public LibrariesDto findLibruaryDtoById(Long id) {
        return convertToLibruaryDto(libraryRepository.findOne(id));
    }

    @Override
    public List<LibrariesDto> findLibruaryDtos() {

        return libruariesToDto(libraryRepository.findAll());
    }

//    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
//    public LibrariesDto findLibraryById(final Long libraryId) {
//        Library library = libraryRepository.findOne(libraryId);
//        LibrariesDto librariesDto = convertToLibruaryDto(library);
//
//        return librariesDto;
////        return (LibrariesDto) template.execute(new HibernateCallback() {
////            public Object doInHibernate(Session session) throws HibernateException, SQLException {
////                LibrariesDto library = (LibrariesDto) session.createQuery(
////                "SELECT lib.id AS id, lib.libraryNm AS libraryNm, lib.folderNm AS folderNm, " +
////                "lib.filepath AS filepath, lib.libraryType AS libraryType " +
////                "FROM Libraries lib WHERE lib.id = :libraryId")
////                .setInteger("libraryId", libraryId)
////                .setResultTransformer(Transformers.aliasToBean(LibrariesDto.class))
////                .uniqueResult();
////
////                if (library == null) {
////                    return null;
////                } else if (user.isSuperadmin() || Utils.isImageAdmin(user, facade)) {
////                    library.setCanUse(true);
////                    library.setCanChange(true);
////
////                    return library;
////                }
////
////                List<Integer> roleIds = user.getRoleIds();
////                if (roleIds.isEmpty()) {
////                    return library;
////                }
////
////                boolean canUse = session.createQuery(
////                        "SELECT DISTINCT lr.permissions FROM LibraryRoles lr WHERE lr.libraryId = :libraryId AND lr.roleId IN (:roleIds)" +
////                                " AND lr.canUse = 1 OR lr.canChange = 1")
////                        .setInteger("libraryId", libraryId)
////                        .setParameterList("roleIds", roleIds)
////                        .list().size() > 0L;
////
////                library.setCanUse(canUse);
////                library.setCanChange(false);
////
////                return library;
////            }
////        });
////
//
//    }
}
