/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.tag.func;

import com.imcode.imcms.addon.imagearchive.dto.LibraryEntryDto;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.sanselan.common.RationalNumber;
import org.apache.sanselan.common.RationalNumberUtilities;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class Functions {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\r\n?");

    public static String newlineToBr(String value) {
        if (value == null) {
            return null;
        }
        return NEWLINE_PATTERN.matcher(value).replaceAll("<br/>");
    }

    public static String abbreviate(String value, int maxLength) {
        return StringUtils.abbreviate((String)value, (int)maxLength);
    }

    public static <T> String join(Collection<T> elements, String separator) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<T> it = elements.iterator();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static boolean isInArchive(LibraryEntryDto img, PageContext pageContext) {
        if (img == null) {
            return false;
        }
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)pageContext.getServletContext());
        Facade facade = (Facade)context.getBean("facade");
        List archiveImages = facade.getImageService().getAllImages();
        for (Image image : archiveImages) {
            if (!image.getName().equals(img.getFileName()) || image.getFileSize() != img.getFileSize()) continue;
            return true;
        }
        return false;
    }

    public static boolean canAccessPreferences(PageContext pageContext) {
        return true;
    }

    public static String doubleToFractionsString(Double number) {
        if (number == null) {
            return null;
        }
        RationalNumber rationalNumber = RationalNumberUtilities.getRationalNumber((double)number);
        return rationalNumber.numerator + "/" + rationalNumber.divisor;
    }

    public static boolean isImageAdmin(PageContext pageContext) {
        return true;
    }
}

