/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.repository.CategoryRepository;
import com.imcode.imcms.addon.imagearchive.service.CategoryService;
import com.imcode.imcms.addon.imagearchive.service.exception.CategoryExistsException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CategoryServiceImpl
implements CategoryService {
    @Autowired
    private CategoryRepository repository;

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean existsCategory(String categoryName) {
        return this.repository.findByName(categoryName) != null;
    }

    public Category createCategory(String categoryName) throws CategoryExistsException {
        if (this.repository.findByName(categoryName) != null) {
            throw new CategoryExistsException();
        }
        Category category = new Category(categoryName);
        return (Category)this.repository.save(category);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Category getCategory(Long categoryId) {
        return (Category)this.repository.findOne(categoryId);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Category> getCategories() {
        return this.repository.findAll();
    }

    public void deleteCategory(Long categoryId) {
        this.repository.delete(categoryId);
    }

    public void updateCategory(Long categoryId, String categoryName) throws CategoryExistsException {
        Category existsCategory = (Category)this.repository.findOne(categoryId);
        if (existsCategory != null && this.repository.findByName(categoryName) == null) {
            existsCategory.setName(categoryName);
            this.repository.save(existsCategory);
        }
    }
}

