/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AccessCodeFilter
implements Filter {
    private static final Log log = LogFactory.getLog(AccessCodeFilter.class);
    private static final String CODE_PARAMETER = "code";
    private static final char CODE_SEPARATOR = ';';
    private FilterConfig filterConfig = null;
    private Facade facade;
    private Config config;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.filterConfig = filterConfig;
        this.facade = (Facade)context.getBean(Facade.class);
        this.config = (Config)context.getBean(Config.class);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String code = httpRequest.getParameter(CODE_PARAMETER);
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.putAll(httpRequest.getParameterMap());
        params.remove(CODE_PARAMETER);
        String queryString = Utils.buildQueryStringMulti(params) + ';' + this.config.getAccessCode();
        String queryMd5 = Utils.md5Custom(queryString);
        if (code == null || !code.equalsIgnoreCase(queryMd5)) {
            httpResponse.sendError(401);
            return;
        }
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public void destroy() {
    }

    public static void main(String[] args) {
        HashMap<Integer, Integer> m1 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> m2 = new HashMap<Integer, Integer>();
        m1.put(1, 1);
        m1.put(2, 2);
        m1.put(3, 3);
        m1.put(4, 4);
        m2.putAll(m1);
        System.out.println(m2);
    }
}

