/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.command;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SaveRoleCategoriesCommand
implements Serializable {
    private static final long serialVersionUID = 8195144106210986876L;
    private boolean canUse;
    private boolean canChange;
    private String categoryIds;
    private List<CategoryRight> assignedCategoryIds;

    public String getCategoryIds() {
        return this.categoryIds;
    }

    public void setCategoryIds(String categoryIds) {
        if ((categoryIds = StringUtils.trimToNull((String)categoryIds)) != null) {
            String[] parts = categoryIds.split("-");
            this.assignedCategoryIds = new ArrayList<CategoryRight>(parts.length);
            for (String part : parts) {
                try {
                    String[] catRightsPart = part.split(",");
                    if (catRightsPart.length != 3) continue;
                    CategoryRight categoryRight = new CategoryRight();
                    categoryRight.setCategoryId(Integer.parseInt(catRightsPart[0], 10));
                    categoryRight.setCanUse("1".equals(catRightsPart[1]));
                    categoryRight.setCanEditOrAdd("1".equals(catRightsPart[2]));
                    if (!categoryRight.isCanUse() && !categoryRight.isCanEditOrAdd()) continue;
                    this.assignedCategoryIds.add(categoryRight);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.categoryIds = categoryIds;
    }

    public List<CategoryRight> getAssignedCategoryIds() {
        return this.assignedCategoryIds;
    }

    public boolean isCanChange() {
        return this.canChange;
    }

    public void setCanChange(boolean canChange) {
        this.canChange = canChange;
    }

    public boolean isCanUse() {
        return this.canUse;
    }

    public void setCanUse(boolean canUse) {
        this.canUse = canUse;
    }

    public class CategoryRight
    implements Serializable {
        boolean canUse;
        boolean canEditOrAdd;
        Integer categoryId;

        public boolean isCanUse() {
            return this.canUse;
        }

        public void setCanUse(boolean canUse) {
            this.canUse = canUse;
        }

        public boolean isCanEditOrAdd() {
            return this.canEditOrAdd;
        }

        public void setCanEditOrAdd(boolean canEditOrAdd) {
            this.canEditOrAdd = canEditOrAdd;
        }

        public Integer getCategoryId() {
            return this.categoryId;
        }

        public void setCategoryId(Integer categoryId) {
            this.categoryId = categoryId;
        }
    }
}

