<%@ page contentType="text/css" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
* {
    margin: 0;
    padding: 0;
}

*, *:before, *:after {
  -moz-box-sizing: border-box; -webkit-box-sizing: border-box; box-sizing: border-box;
}

html {
    height: 100%;
}

body {
    font-family: Tahoma,Arial,sans-serif;
}

.mainTable {
    margin-left:auto;
    margin-right:auto;
}

input, select, th, td {
    font-size: 1em;
}

.right {
    float: right !important;
}

.left {
    float: left !important;
}

.clearboth {
    clear: both !important;
}

.center {
    text-align: center !important;
}

.clearheight {
    clear: both;
    height: 0;
    overflow: hidden;
}

/* slightly enhanced, universal clearfix hack */
.clearfix:after {
     visibility: hidden;
     display: block;
     font-size: 0;
     content: " ";
     clear: both;
     height: 0;
     }
.clearfix { display: inline-block; }
/* start commented backslash hack \*/
* html .clearfix { height: 1%; }
.clearfix { display: block; }
/* close commented backslash hack */

.m10t {
    margin-top: 10px !important;
}

.m15t {
    margin-top: 15px !important;
}

.m10b {
    margin-bottom: 10px !important;
}

.h10 {
    height: 10px !important;
}

.red {
    color: red;
}

a {
    color: #06f;
    cursor: pointer;
    text-decoration: underline;
}

a.imgLink {
    text-decoration: none;
}

img, table {
    border: 0 none;
}

.inBtnGroup {
    margin-right: 5px;
}

a.imcmsFormBtnSmall.disabled, input.imcmsFormBtnSmall.disabled, a.imcmsFormBtn.disabled, input.imcmsFormBtn.disabled {
    background-color: #B8C6D5;
    border: 1px outset #DAE4EF;
    border-color: #DAE4EF #999999 #999999 #DAE4EF;
}

.btnBack {
	float: left !important;
}

/* fixes input submit, button etc in firefox */
input[type="button"].imcmsFormBtn::-moz-focus-inner, input[type="submit"].imcmsFormBtn::-moz-focus-inner, button.imcmsFormBtn::-moz-focus-inner,
input[type="button"].imcmsFormBtnSmall::-moz-focus-inner, input[type="submit"].imcmsFormBtnSmall::-moz-focus-inner, button.imcmsFormBtnSmall::-moz-focus-inner
{
    border:0;
}

.imcmsSpecialButton {
    background-color: #20568D;
    border-color: #466D96 #333333 #333333 #466D96;
    border-style: outset;
    border-width: 1px;
    color: #FFFFFF;
    cursor: pointer;
    font: 10px Tahoma,Arial,sans-serif;
    padding: 1px 2px;
}

.imcmsFormBtn, .imcmsFormBtnSmall {
    text-decoration:none;
}

.btnBack span {
	display: block;
	text-align: center;

	min-width: 50px;
	width: auto !important;
	width: 50px;
}

#containerTop, #containerContent {
    margin: 0 auto !important;
    padding-right: 20px;
    padding-left: 20px;
}

#containerContent {
    clear: both !important;
    padding-top: 10px;
    padding-bottom: 20px;
    width:890px;
}

#containerTop {
    background-color: #20568D;
    color: #fff;
}

#backButton {
    margin-bottom: 15px;
}

ul.tabs {
    list-style-type:none;
    font-size: 0.7916em;
    font-weight: 600;
}
ul.tabs li {
    float: left !important;
    font-family: Tahoma, Arial, sans-serif;
    text-align: center;
    color: #fff;
    background-color: #4076ad;
    border: 1px outset #668DB6;
    border-color: #fff #002f5f #333333 #fff;
    border-bottom: 1px solid #20568D;
    padding: 2px 6px;
    cursor: pointer;

    min-width: 80px;
    width: auto !important;
    width: 80px;
}
ul.tabs li.sel {
    background-color: #f5f5f7;
    border: 1px solid #f5f5f7;
    border-color: #f5f5f7 #bababd #f5f5f7 #f5f5f7;
    color: #4076ad;
    cursor: default;
}
ul.tabs a {
    text-decoration: none;
    color: #fff;
}
li.sel a {
	color: #4076ad;
}

.pageHeading {
    font-family: Tahoma,Arial,Verdana,sans-serif;
    font-weight: bold;
    font-size: 1.416em;
}

.minH30 {
    padding-bottom: 13px;
}

.infoCol {
    width:530px;
    float:right;
}

.infoRow {
	padding:3px 2px;
}

.infoLabel {
    width: 150px;
    float: left;
}

label.withCheckbox {
    margin-left: 3px;
}

.infoValue {
    width: 304px;
    float: left;
}

.minW60 {
	min-width: 60px;
	width: auto !important;
	width: 60px;
}

.detailedTooltipThumb {
    background: white;
    border:1px solid #888;
    width:160px;
    margin-right:10px;
    padding:5px 0;
}

.roleTable th, .roleTable td {
    padding: 5px;
}

.libraryCategoriesTable th, .libraryCategoriesTable td {
    padding: 5px;
    text-align: left;
}

.editCategoryTable input[disabled], .editKeywordTable input[disabled]{
    border: none;
    background: white;
}

.placeholdersjs {
    color: gray;
    font-style: italic;
}

::-webkit-input-placeholder {
    color: gray;
    font-style: italic;
}

:-moz-placeholder { /* Firefox 18- */
    color: gray;
    font-style: italic;
}

::-moz-placeholder {  /* Firefox 19+ */
    color: gray;
    font-style: italic;
}

:-ms-input-placeholder {
    color: gray;
    font-style: italic;
}

#existingKeywordList {
    display: none;
    z-index: 10;
    position: absolute;
    top: 0;
    left: 0;
    border: 1px solid black;
    list-style: none;
    background: white;
    box-sizing: border-box;
}

#existingKeywordList li {
    font-size: 11px;
    color: gray;
    padding: 1px 3px;
}

#existingKeywordList li.header {
    font-style: italic;
}

.imcmsAdmHeading {
    padding-bottom: 15px;
    border-bottom:1px solid #20568D;
}


/* uploadify button */
div.UploadifyButtonWrapper{
    position:relative;
    float: left;
    margin-right: 5px;
}

/* fake button */
div.UploadifyButtonWrapper button {
    position:absolute; /* relative to UploadifyButtonWrapper */
    top:0;
    left:0;
    z-index:0;
    display:block;
    float:left;
}

/* pass hover effects to button */
div.UploadifyButtonWrapper a.Hover {
    background:orange;
    color:white;
}

/* position flash button above css button */
div.UploadifyObjectWrapper {
    position:relative;
    z-index:10;
}


/* external files libraries and file table */
#listOfLibraries, #listOfLibraries ul {
    list-style-type: none;
}

#listOfLibraries li {
    cursor: pointer;
    padding-top:2px;
    padding-bottom:2px;
}

#listOfLibraries li img {
    padding-right: 5px;
}

#listOfLibraries {
    padding:0 5px 5px 5px;
}

#listOfLibraries ul {
    padding-left:40px;
}

.currentLibrary {
    font-weight: bold;
}

/* export dialog */
#exportOverlay {
    background-color:#fff;
    border:1px solid black;
    padding-top:10px;
    width: 360px;
    position: fixed;
    top: 50%;
    left: 50%;
    z-index: 1001;
    display: none;
}

#exportOverlay .imcmsAdmHeading {
    padding-left:10px;
}

.fixedWidth {
    width:80px;
}

.fixedWidthInput {
    width:100px;margin-left:5px;
}

#exportImage {
    padding:50px 45px 30px 45px;
}

.exportBtns {
    text-align:right;
    margin-top:25px;
}

table.tablesorter tr.odd td, div.odd, .editCategoryTable tr.odd td, .editCategoryTable tr.odd input.disabled,
.editKeywordTable tr.odd td, .editKeywordTable tr.odd input.disabled{
    background-color: white;
}

table.tablesorter tr.odd td, div.odd, .editCategoryTable tr.odd td, .editCategoryTable tr.odd,
.editKeywordTable tr.odd td, .editKeywordTable tr.odd {
    background-color: rgb(211, 234, 255);
}

#externalFilesUpload {
    margin-top:15px;
    margin-bottom:15px;
}

#externalFiles {
    margin-top:15px;
}

.externalFilesLibrariesAndEntries {
    width: 100%;
}

.externalFilesLibrariesAndEntries .tableSeparatorTop {
    background: url(${pageContext.request.contextPath}/images/grayLine.png) 50% 150% no-repeat;width:20px;
}

.externalFilesLibrariesAndEntries .tableSeparatorMiddle {
    background: url(${pageContext.request.contextPath}/images/grayDot.png) 50% 0 repeat-y;
}

.listOfLibrariesCell {
    vertical-align:top;
    width:230px;
}

.hint {
    color:gray;
    font-style: italic;
    font-weight: normal;
}

.addImageControls {
    margin-bottom: 15px;
}

.tablesorter .labelCell {
    width:60%;
}

.tablesorter .widerLabelCell {
    width:80%;
}

.tablesorter td.useCell, .tablesorter td.editCell {
    text-align: center;
}

.preferencesSection {
    margin-bottom: 15px;
}

.editCategoryTable td, .editKeywordTable td {
    padding: 3px 2px;
}

.editCategoryTable th.header, .editKeywordTable th.header {
    width:320px;
}

.editCategoryTable input, .editKeywordTable input {
    width:99%;
}

.colapsableLabel .indicator {
    padding-left: 25px;
    padding-right: 10px;
    color: black;
    font-weight: normal;
}

.colapsableLabel .indicator.folded {
    background: url('${pageContext.request.contextPath}/images/show.png') center left no-repeat;
}

.colapsableLabel .indicator.unfolded {
    background: url('${pageContext.request.contextPath}/images/hide.png') center left no-repeat;
}

#lightbox {
    position: fixed;
    top: 50%;
    left: 50%;
    width: 500px;
    background: #fff;
    z-index: 1001;
    display: none;
}

#lightbox-shadow, #overlay-shadow {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: #000;
    filter: alpha(opacity=75);
    -moz-opacity: 0.75;
    -khtml-opacity: 0.75;
    opacity: 0.75;
    z-index: 1000;
    display: none;
}

#lightbox-close {
    position: fixed;
    top: 50%;
    left: 50%;
    width: 35px;
    height: 35px;
    z-index: 1003;
    display: none;
    color: white;
    background: url('${pageContext.request.contextPath}/images/close.png') top left no-repeat;
    cursor: pointer;
}

.backToSearchResultsBtn {
    margin-bottom: -17px;
}

#multiFileUploadData {
    margin-left: 20px;
    float:left;
    display:none;
}

.dataFormButtons {
    margin-top: 20px;
    text-align:right;
}