package com.imcode.imcms.addon.imagearchive.util;

import com.imcode.imcms.addon.imagearchive.SessionConstants;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.UserService;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang3.ObjectUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;


public class SessionUtils {

	private final static String CONTENT_MANAGEMENT_SYSTEM_REQUEST_ATTRIBUTE = "com.imcode.imcms.ImcmsSystem";

	private SessionUtils() {
	}

	public static User getUser(HttpServletRequest request, HttpSession session, Facade facade) {
		User user = (User) session.getAttribute(SessionConstants.USER);
        Long userId = 1L;
//		Long userId = null;
		Object cms = request.getAttribute(CONTENT_MANAGEMENT_SYSTEM_REQUEST_ATTRIBUTE);
		if (cms != null) {
			BeanMap introspected = new BeanMap(cms);
			if (introspected.containsKey("currentUser")) {
				BeanMap objectUser = new BeanMap(introspected.get("currentUser"));

				userId = Long.valueOf(ObjectUtils.toString(objectUser.get("id"), "2"));
			}
		}

		if (user == null || Long.valueOf(user.getId()).equals(userId)) {
			UserService service = facade.getUserService();
			user = service.findUserById(userId);
			session.setAttribute(SessionConstants.USER, user);
		}

		return user;
	}

	public static String getImcmsReturnToUrl(HttpSession session) {
		return (String) session.getAttribute(SessionConstants.IMCMS_RETURN_URL);
	}
}
