package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.repository.UserRepository;
import com.imcode.imcms.addon.imagearchive.service.UserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

@Service
@Transactional
public class UserServiceImpl implements UserService {
    private static final Log log = LogFactory.getLog(UserService.class);

    @Autowired
    private UserRepository userRepository;

    public List<Role> findUserRoles(long userId) {
        return new ArrayList<Role>(userRepository.findOne(userId).getRoles());
    }

    public User findUserById(long userId) {
        return userRepository.findOne(userId);
    }

//    @Autowired
//    private Facade facade;
//    @Autowired
//    private HibernateTemplate template;
//
//
//    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
//    public User findUserById(int usersId) {
//        return (User) template.get(User.class, usersId);
//    }
//
//    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
//    public User findUserByRememberCd(final String rememberCd) {
//        return (User) template.execute(new HibernateCallback() {
//            public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                return session.createQuery("SELECT u FROM Users u WHERE u.rememberCd = :code AND u.active IS TRUE")
//                        .setString("code", rememberCd)
//                        .uniqueResult();
//            }
//        });
//    }
//
//    @SuppressWarnings("unchecked")
//    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
//    public List<Role> findUserRoles(final int usersId) {
//        return template.find("SELECT u.roles FROM Users u WHERE u.userId = ?", usersId);
//    }
//
//    /*
//    Returns a set of role ids that have the given permissions(use/change/any)
//    categoryIds restrict search to the given category ids. CategoryIds = null means permissions for any category
//    */
//    public Set<Integer> getRoleIdsWithPermission(User user, final List<Integer> categoryIds, int... permissions) {
//        Set<Integer> roleIds = new HashSet<Integer>();
//
//        for (final Role role : user.getRoles()) {
//            for (int permission : permissions) {
//                final StringBuffer queryStr = new StringBuffer("SELECT cr.roleId FROM CategoryRoles cr WHERE cr.roleId = :userRoleId");
//                if (categoryIds != null && categoryIds.size() > 0) {
//                    queryStr.append(" and cr.categoryId IN (:categoryIds)");
//                }
//
//                if (Role.PERMISSION_USE_IMAGE == permission) {
//                    Integer count = (Integer) template.execute(new HibernateCallback() {
//                        public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                            queryStr.append(" and cr.canUse = 1");
//                            Query query = session.createQuery(queryStr.toString());
//                            query.setInteger("userRoleId", role.getId());
//                            if (categoryIds != null && categoryIds.size() > 0) {
//                                query.setParameterList("categoryIds", categoryIds);
//                            }
//
//                            return query.list().size();
//                        }
//                    });
//
//                    if (count > 0) {
//                        roleIds.add(role.getId());
//                    }
//                } else if (Role.PERMISSION_CHANGE_IMAGE == permission) {
//                    Integer count = (Integer) template.execute(new HibernateCallback() {
//                        public Object doInHibernate(Session session) throws HibernateException, SQLException {
//                            queryStr.append(" and cr.canChange = 1");
//                            Query query = session.createQuery(queryStr.toString());
//                            query.setInteger("userRoleId", role.getId());
//                            if (categoryIds != null && categoryIds.size() > 0) {
//                                query.setParameterList("categoryIds", categoryIds);
//                            }
//
//                            return query.list().size();
//                        }
//                    });
//
//                    if (count > 0) {
//                        roleIds.add(role.getId());
//                    }
//                }
//            }
//        }
//
//        return roleIds;
//    }
}
