package com.imcode.imcms.addon.imagearchive.entity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Set;

@Entity
@Table(name="roles")
public class Role implements Serializable {
    private static final long serialVersionUID = -9207677278215773638L;

    public static final int SUPERADMIN_ID = 0;
    public static final int USERADMIN_ID = 1;
    public static final int USERS_ID = 2;
    
    public static final int PERMISSION_USE_IMAGE = (1 << 22);
    public static final int PERMISSION_CHANGE_IMAGE = (1 << 23);
    public static final int[] ALL_PERMISSIONS = {
        PERMISSION_USE_IMAGE,
        PERMISSION_CHANGE_IMAGE
    };
    
    
    @Id
    @Column(name="role_id", nullable=false)
    @GeneratedValue
    private int id;
    
    @Column(name="role_name", length=60, nullable=false, unique=true)
    private String name;
    
    @Column(name="permissions", nullable=false)
    private int permissions;
    
    @Column(name="admin_role", nullable=false)
    private int adminRole;

    @OneToMany(fetch = FetchType.EAGER)
    @JoinColumn(name = "role_id", referencedColumnName = "role_id", insertable=false, updatable=false)
    private Set<CategoryRoles> categoryRoles;

    public Role() {
    }

    public Role(int id) {
        this.id = id;
    }

    /*public boolean canAccess(Category category, int permission) {
        for(CategoryRoles categoryRole: getCategoryRoles()) {
            if(category.equals(categoryRole.getCategory())) {
                if(permission == PERMISSION_USE_IMAGE) {
                    return categoryRole.getCanUse();
                } else if(permission == PERMISSION_CHANGE_IMAGE) {
                    return categoryRole.getCanChange();
                }
            }
        }

        return false;
    }*/

    public boolean isSuperadmin() {
        return id == SUPERADMIN_ID;
    }

    public boolean isCanUseImage() {
        return (permissions & PERMISSION_USE_IMAGE) == PERMISSION_USE_IMAGE;
    }

    public boolean isCanChangeImage() {
        return (permissions & PERMISSION_CHANGE_IMAGE) == PERMISSION_CHANGE_IMAGE;
    }

    public int getAdminRole() {
        return adminRole;
    }

    public void setAdminRole(int adminRole) {
        this.adminRole = adminRole;
    }

    public int getPermissions() {
        return permissions;
    }

    public void setPermissions(int permissions) {
        this.permissions = permissions;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<CategoryRoles> getCategoryRoles() {
        return categoryRoles;
    }

    public void setCategoryRoles(Set<CategoryRoles> categoryRoles) {
        this.categoryRoles = categoryRoles;
    }
    
    
    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        
        if (getClass() != obj.getClass()) {
            return false;
        }
        
        final Role other = (Role) obj;
        if (this.id != other.id) {
            return false;
        }
        
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.id;
        
        return hash;
    }

    @Override
    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.Role[id: %d, name: %s, permissions: %d]",
                id, name, permissions);
    }
}
