/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.validator;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.image.ImageInfo;
import com.imcode.imcms.addon.imagearchive.util.image.ImageOp;
import java.io.File;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class ImageUploadValidator
implements Validator {
    private static final Log log = LogFactory.getLog(ImageUploadValidator.class);
    private Facade facade;
    private File tempFile;
    private ImageInfo imageInfo;
    private String imageName;
    private boolean zipFile;

    public ImageUploadValidator(Facade facade) {
        this.facade = facade;
    }

    public boolean supports(Class clazz) {
        return MultipartFile.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate(Object target, Errors errors) {
        File localTempFile;
        MultipartFile file;
        block22: {
            block21: {
                file = (MultipartFile)target;
                localTempFile = null;
                if (file == null || file.isEmpty()) {
                    errors.rejectValue("file", "addImage.invalidImageError");
                    return;
                }
                try {
                    this.imageName = file.getOriginalFilename();
                    this.tempFile = this.facade.getImageService().uploadFile(file.getBytes());
                    localTempFile = File.createTempFile("" + Math.random() * 1000.0, ".tmp");
                    file.transferTo(localTempFile);
                    ZipFile zip = null;
                    try {
                        zip = new ZipFile(localTempFile, 1);
                        this.zipFile = true;
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (zip != null) {
                            zip.close();
                        }
                    }
                    long maxZipUploadSize = this.facade.getConfig().getMaxZipUploadSize();
                    long maxImageUploadSize = this.facade.getConfig().getMaxImageUploadSize();
                    long fileLength = localTempFile.length();
                    double size = 0.0;
                    boolean sizeError = false;
                    if (this.zipFile && fileLength > maxZipUploadSize) {
                        sizeError = true;
                        size = maxZipUploadSize;
                    } else if (!this.zipFile && fileLength > maxImageUploadSize) {
                        sizeError = true;
                        size = maxImageUploadSize;
                    }
                    if (sizeError) {
                        errors.rejectValue("file", "addImage.sizeError", new Object[]{size /= 1048576.0}, "???");
                        FileUtils.deleteQuietly((File)localTempFile);
                        break block21;
                    }
                    if (!this.zipFile) {
                        this.imageInfo = ImageOp.getImageInfo((Config)this.facade.getConfig(), (File)localTempFile);
                        if (this.imageInfo == null || this.imageInfo.getFormat() == null || this.imageInfo.getWidth() < 1 || this.imageInfo.getHeight() < 1) {
                            errors.rejectValue("file", "addImage.invalidImageError");
                            localTempFile.delete();
                            this.facade.getFileService().deleteTemporaryFile(this.tempFile);
                        }
                    }
                    FileUtils.deleteQuietly((File)localTempFile);
                    break block22;
                }
                catch (Exception ex) {
                    errors.rejectValue("file", "addImage.invalidImageError");
                    return;
                }
            }
            if (!(file instanceof CommonsMultipartFile)) return;
            ((CommonsMultipartFile)file).getFileItem().delete();
            return;
        }
        if (!(file instanceof CommonsMultipartFile)) return;
        ((CommonsMultipartFile)file).getFileItem().delete();
        return;
        finally {
            FileUtils.deleteQuietly(localTempFile);
            if (file instanceof CommonsMultipartFile) {
                ((CommonsMultipartFile)file).getFileItem().delete();
            }
        }
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public String getImageName() {
        return this.imageName;
    }

    public boolean isZipFile() {
        return this.zipFile;
    }
}

