/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.tag.pagination;

import com.imcode.imcms.addon.imagearchive.tag.pagination.Page;
import com.imcode.imcms.addon.imagearchive.util.Pagination;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginationTag
extends BodyTagSupport {
    private static final Log logger = LogFactory.getLog(PaginationTag.class);
    public static final String PAGE_MARKER = "[page]";
    private static final String ELLIPSE = "...";
    private String contClass;
    private String contStyle;
    private String currentPageClass;
    private String currentPageStyle;
    private String nextText = "next";
    private String prevText = "previous";
    private String pageUrl;
    private String onchange;
    private Pagination pag;
    private int currentPage;
    private int pageCount;
    private int pagesBeforeEllipse;
    private int capacity;

    public int doAfterBody() throws JspException {
        if (this.pag != null) {
            this.currentPage = this.pag.getCurrentPage();
            this.pageCount = this.pag.getPageCount();
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        StringBuilder builder = new StringBuilder();
        builder.append("<div ");
        PaginationTag.renderStyle(this.contClass, this.contStyle, builder);
        builder.append(">");
        List<Page> pages = this.calculatePages();
        this.renderPagingControl(this.currentPage > 0, this.currentPage, this.prevText, builder);
        for (Page page : pages) {
            if (page.isEllipse()) {
                PaginationTag.renderSpan(ELLIPSE, builder);
                continue;
            }
            if (page.isSelected()) {
                builder.append("<span ");
                PaginationTag.renderStyle(this.currentPageClass, this.currentPageStyle, builder);
                builder.append(">");
                builder.append(page.getPage() + 1);
                builder.append("</span> ");
                continue;
            }
            builder.append("<a ");
            if (this.pageUrl != null) {
                builder.append("href=\"");
                String url = request.getContextPath() + this.pageUrl.replace(PAGE_MARKER, Integer.toString(page.getPage() + 1));
                builder.append(response.encodeURL(url));
                builder.append("\" ");
            } else {
                builder.append("href=\"#\"");
                builder.append(String.format("onclick=\"(function(page){%s;})(%d);return false;\" ", this.onchange, page.getPage() + 1));
            }
            builder.append(">");
            builder.append(page.getPage() + 1);
            builder.append("</a> ");
        }
        this.renderPagingControl(this.currentPage < this.pageCount - 1, this.currentPage + 2, this.nextText, builder);
        builder.append("</div> ");
        try {
            JspWriter out = this.bodyContent.getEnclosingWriter();
            out.print(builder.toString());
        }
        catch (IOException ex) {
            logger.fatal((Object)ex.getMessage());
        }
        return 0;
    }

    private static void renderSpan(String content, StringBuilder builder) {
        builder.append("<span>");
        builder.append(content);
        builder.append("</span> ");
    }

    private void renderPagingControl(boolean enabled, int page, String controlText, StringBuilder builder) {
        if (!enabled) {
            builder.append("<span>");
            builder.append(StringEscapeUtils.escapeHtml4((String)controlText));
            builder.append("</span> ");
        } else {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            builder.append("<a ");
            if (this.pageUrl != null) {
                builder.append("href=\"");
                String url = request.getContextPath() + this.pageUrl.replace(PAGE_MARKER, Integer.toString(page));
                builder.append(response.encodeURL(url));
                builder.append("\" ");
            } else {
                builder.append("href=\"#\" ");
                builder.append(String.format("onclick=\"(function(page){%s})(%d);return false;\" ", this.onchange, page));
            }
            builder.append(">");
            builder.append(StringEscapeUtils.escapeHtml4((String)controlText));
            builder.append("</a> ");
        }
    }

    private static void renderStyle(String styleClass, String style, StringBuilder builder) {
        if (styleClass != null) {
            builder.append("class=\"");
            builder.append(styleClass);
            builder.append("\" ");
        }
        if (style != null) {
            builder.append("style=\"");
            builder.append(style);
            builder.append("\" ");
        }
    }

    private List<Page> calculatePages() {
        int pagesBeforeCenter;
        ArrayList<Page> pages = new ArrayList<Page>();
        if (this.pageCount < 1) {
            return pages;
        }
        this.currentPage = Math.min(this.currentPage, this.pageCount - 1);
        this.currentPage = Math.max(this.currentPage, 0);
        int centerPagesCount = this.capacity - (this.pagesBeforeEllipse * 2 + 2);
        if (centerPagesCount < 1 || centerPagesCount % 2 != 1) {
            logger.fatal((Object)"PaginationTag misconfigured, wrong capacity or pagesBeforeEllipse");
        }
        int pagesBetweenEllipseAndCenter = (centerPagesCount - 1) / 2;
        int centerPage = pagesBeforeCenter = pagesBetweenEllipseAndCenter + this.pagesBeforeEllipse + 1;
        int pageOneAfterCenter = pagesBeforeCenter + 1;
        if (this.pageCount <= this.capacity) {
            for (int i = 0; i < this.pageCount; ++i) {
                if (i == this.currentPage) {
                    pages.add(Page.selected(i));
                    continue;
                }
                pages.add(Page.page(i));
            }
        } else if (this.currentPage <= pagesBeforeCenter) {
            for (int i = 0; i < pageOneAfterCenter; ++i) {
                if (i == this.currentPage) {
                    pages.add(Page.selected(i));
                    continue;
                }
                pages.add(Page.page(i));
            }
            int distFromEnd = this.pageCount - 1 - pagesBeforeCenter;
            if (distFromEnd == pagesBeforeCenter) {
                for (int i = pageOneAfterCenter; i < this.pageCount; ++i) {
                    pages.add(Page.page(i));
                }
            } else {
                int i;
                for (i = pageOneAfterCenter; i < pageOneAfterCenter + pagesBetweenEllipseAndCenter; ++i) {
                    pages.add(Page.page(i));
                }
                pages.add(Page.ellipse());
                for (i = this.pageCount - this.pagesBeforeEllipse; i < this.pageCount; ++i) {
                    pages.add(Page.page(i));
                }
            }
        } else {
            for (int i = 0; i < this.pagesBeforeEllipse; ++i) {
                pages.add(Page.page(i));
            }
            pages.add(Page.ellipse());
            centerPage = this.pageCount - 1 - pagesBeforeCenter;
            int distFromEnd = this.pageCount - 1 - this.currentPage;
            if (distFromEnd <= pagesBeforeCenter) {
                for (int i = centerPage - pagesBetweenEllipseAndCenter; i < this.pageCount; ++i) {
                    if (i == this.currentPage) {
                        pages.add(Page.selected(i));
                        continue;
                    }
                    pages.add(Page.page(i));
                }
            } else {
                int i;
                for (i = this.currentPage - pagesBetweenEllipseAndCenter; i < this.currentPage + pagesBetweenEllipseAndCenter + 1; ++i) {
                    if (i == this.currentPage) {
                        pages.add(Page.selected(i));
                        continue;
                    }
                    pages.add(Page.page(i));
                }
                pages.add(Page.ellipse());
                for (i = this.pageCount - this.pagesBeforeEllipse; i < this.pageCount; ++i) {
                    pages.add(Page.page(i));
                }
            }
        }
        return pages;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public Pagination getPag() {
        return this.pag;
    }

    public void setPag(Pagination pag) {
        this.pag = pag;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public String getOnchange() {
        return this.onchange;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public int getPagesBeforeEllipse() {
        return this.pagesBeforeEllipse;
    }

    public void setPagesBeforeEllipse(int pagesBeforeEllipse) {
        this.pagesBeforeEllipse = pagesBeforeEllipse;
    }

    public String getContClass() {
        return this.contClass;
    }

    public void setContClass(String contClass) {
        this.contClass = contClass;
    }

    public String getContStyle() {
        return this.contStyle;
    }

    public void setContStyle(String contStyle) {
        this.contStyle = contStyle;
    }

    public String getCurrentPageClass() {
        return this.currentPageClass;
    }

    public void setCurrentPageClass(String currentPageClass) {
        this.currentPageClass = currentPageClass;
    }

    public String getCurrentPageStyle() {
        return this.currentPageStyle;
    }

    public void setCurrentPageStyle(String currentPageStyle) {
        this.currentPageStyle = currentPageStyle;
    }

    public String getNextText() {
        return this.nextText;
    }

    public void setNextText(String nextText) {
        this.nextText = nextText;
    }

    public String getPrevText() {
        return this.prevText;
    }

    public void setPrevText(String prevText) {
        this.prevText = prevText;
    }
}

