package com.imcode.imcms.addon.imagearchive.dto;

import java.io.File;
import java.io.Serializable;

public class LibrariesDto implements Serializable {
    private static final long serialVersionUID = -2489487888347287580L;
    
    private String folderNm;
    private String filepath;

    public LibrariesDto() {
    }

    public LibrariesDto(File path) {
        this.filepath = path.getParent();
        this.folderNm = path.getName();
    }

    public String getFolderNm() {
        return folderNm;
    }

    public String getFilepath() {
        return filepath;
    }

    public void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    public void setFolderNm(String folderNm) {
        this.folderNm = folderNm;
    }

    public String getFullPath() {
        return filepath + "/" + folderNm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LibrariesDto)) return false;

        LibrariesDto that = (LibrariesDto) o;

        if (!folderNm.equals(that.folderNm)) return false;
        return filepath.equals(that.filepath);
    }

    @Override
    public int hashCode() {
        int result = folderNm.hashCode();
        result = 31 * result + filepath.hashCode();
        return result;
    }
}
