package com.imcode.imcms.addon.imagearchive.util;

import java.io.Serializable;
import java.util.Collection;

/**
 * Page result class that holds search result for page and pagination data
 *
 * Created by Serhii Maksymchuk from Ubrainians for imCode
 * 24.05.17.
 */
public class PageResult<T> implements Serializable {

    private static final long serialVersionUID = 7707357536876994054L;
    private final Collection<T> result;
    private final Pagination pagination;

    public PageResult(Collection<T> result, Pagination pagination) {
        this.result = result;
        this.pagination = pagination;
    }

    public Collection<T> getResult() {
        return result;
    }

    public Pagination getPagination() {
        return pagination;
    }
}
