package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.service.ImcmsImageService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;

@Service
@Transactional
public class ImcmsImageServiceImpl implements ImcmsImageService {
    private static final Log log = LogFactory.getLog(ImcmsImageServiceImpl.class);

    public String storeImage(byte[] imageInBytes, long imageId, File imagesPath) {
        String filename = String.format("archive_img%d.jpg", imageId);

        File imcmsFile = new File(imagesPath, filename);

        try {
            FileUtils.writeByteArrayToFile(imcmsFile, imageInBytes);
        } catch (Exception ex) {
            log.warn(ex.getMessage(), ex);
            imcmsFile.delete();
            return null;
        }
        return filename;
    }
}
