package com.imcode.imcms.addon.imagearchive.entity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Set;

/**
 * Entity describes types of categories
 *
 * @author Serhii Maksymchuk
 */
@Entity
@Table(name = "category_types")
public class CategoryType implements Serializable, Comparable<CategoryType> {
    private static final long serialVersionUID = 3603473838684193107L;

    @Id
    @GeneratedValue
    @Column(name = "category_type_id", nullable = false)
    private Integer id;

    @Column(name = "name", nullable = false)
    private String name;

    @Column(name = "max_choices")
    private Integer maxChoices;

    @Column(name = "inherited")
    private boolean inherited;

    @Column(name = "is_image_archive")
    private boolean isImageArchive;

    @OneToMany
    @JoinColumn(name = "category_type_id", referencedColumnName = "category_type_id", updatable=false)
    private Set<Category> categories;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMaxChoices() {
        return maxChoices;
    }

    public void setMaxChoices(Integer maxChoices) {
        this.maxChoices = maxChoices;
    }

    public boolean isInherited() {
        return inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean isImageArchive() {
        return isImageArchive;
    }

    public void setImageArchive(boolean imageArchive) {
        isImageArchive = imageArchive;
    }

    public int compareTo(CategoryType o) {
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof CategoryType)) return false;

        CategoryType that = (CategoryType) o;

        return id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.CategoryType[id: %d, name: %s]", id, name);
    }

    public Set<Category> getCategories() {
        return categories;
    }

    public void setCategories(Set<Category> categories) {
        this.categories = categories;
    }
}
