/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.util;

import java.io.Serializable;
import javax.servlet.http.HttpSession;

public class Pagination
implements Serializable {
    private static final long serialVersionUID = -7220000190165261133L;
    public static final int DEFAULT_PAGE_SIZE = 20;
    private int pageSize = 1;
    private int startPosition;
    private int currentPage;
    private int pageCount;
    private boolean hasNextPage;
    private boolean hasPrevPage;

    public Pagination() {
    }

    public Pagination(int pageSize) {
        this.pageSize = pageSize;
    }

    public static Pagination create(int pageSize, int currentPage, int elementCount) {
        Pagination pagination = new Pagination(pageSize);
        pagination.setCurrentPage(currentPage);
        pagination.update(elementCount);
        return pagination;
    }

    public static Pagination getPagination(HttpSession session, String paginationKey) {
        return Pagination.getPagination(session, paginationKey, 20);
    }

    public static Pagination getPagination(HttpSession session, String paginationKey, int defaultPageSize) {
        Pagination pag = (Pagination)session.getAttribute(paginationKey);
        if (pag == null) {
            pag = new Pagination(defaultPageSize);
            session.setAttribute(paginationKey, (Object)pag);
        }
        return pag;
    }

    public void update(int elementCount) {
        this.pageCount = (elementCount - 1) / this.pageSize + 1;
        this.currentPage = Math.min(this.currentPage, this.pageCount - 1);
        this.currentPage = Math.max(this.currentPage, 0);
        this.startPosition = this.currentPage * this.pageSize;
        this.startPosition = Math.min(this.startPosition, elementCount - 1);
        this.startPosition = Math.max(this.startPosition, 0);
        this.hasNextPage = this.currentPage < this.pageCount - 1;
        this.hasPrevPage = this.currentPage > 0;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public boolean isHasPrevPage() {
        return this.hasPrevPage;
    }

    public int getPageCount() {
        return this.pageCount;
    }
}

