/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.util.exif;

import com.imcode.imcms.addon.imagearchive.util.exif.ExifData;
import com.imcode.imcms.addon.imagearchive.util.exif.Flash;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.RationalNumber;
import org.apache.sanselan.formats.jpeg.JpegImageMetadata;
import org.apache.sanselan.formats.jpeg.exifRewrite.ExifRewriter;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.constants.ExifTagConstants;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.constants.TiffFieldTypeConstants;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldTypeASCII;
import org.apache.sanselan.formats.tiff.write.TiffOutputField;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ExifUtils {
    private static final DateTimeFormatter tiffExifDateFormat = DateTimeFormat.forPattern((String)"yyyy:MM:dd HH:mm:ss");
    private static final Log log = LogFactory.getLog(ExifUtils.class);
    private static final Pattern HTML_ENTITY_PATTERN = Pattern.compile("&#[0-9a-z]+;");

    public static ExifData getExifData(File file) {
        try {
            Date tmpDate;
            Integer ISO;
            Integer pixelYDimension;
            Integer pixelXDimension;
            String colorSpace;
            RationalNumber focalLength;
            Flash flash;
            String dateOriginal;
            String dateDigitized;
            RationalNumber fStop;
            String exposureProgram;
            RationalNumber exposure;
            Integer resolutionUnit;
            String compression;
            String model;
            String manufacturer;
            RationalNumber yResolution;
            RationalNumber xResolution;
            String artist;
            String copyright;
            String imageDescription;
            ImageFormat imageFormat = Sanselan.guessFormat((File)file);
            if (imageFormat.equals((Object)ImageFormat.IMAGE_FORMAT_UNKNOWN)) {
                return null;
            }
            IImageMetadata metadata = Sanselan.getMetadata((File)file);
            String userComment = null;
            if (metadata instanceof TiffImageMetadata) {
                TiffImageMetadata tiffMetadata = (TiffImageMetadata)metadata;
                imageDescription = (String)ExifUtils.getTiffTagValue(TiffConstants.TIFF_TAG_IMAGE_DESCRIPTION, tiffMetadata);
                copyright = (String)ExifUtils.getTiffTagValue(TiffConstants.TIFF_TAG_COPYRIGHT, tiffMetadata);
                artist = (String)ExifUtils.getTiffTagValue(TiffConstants.TIFF_TAG_ARTIST, tiffMetadata);
                xResolution = (RationalNumber)ExifUtils.getTiffTagValue(TiffConstants.TIFF_TAG_XRESOLUTION, tiffMetadata);
                yResolution = (RationalNumber)ExifUtils.getTiffTagValue(TiffConstants.TIFF_TAG_YRESOLUTION, tiffMetadata);
                manufacturer = (String)ExifUtils.getTiffTagValue(TiffConstants.TIFF_TAG_MAKE, tiffMetadata);
                model = (String)ExifUtils.getTiffTagValue(TiffConstants.TIFF_TAG_MODEL, tiffMetadata);
                compression = ExifUtils.getTiffCompressionName((Integer)ExifUtils.getTiffTagValue(TiffConstants.TIFF_TAG_COMPRESSION, tiffMetadata));
                resolutionUnit = (Integer)ExifUtils.getTiffTagValue(TiffConstants.TIFF_TAG_RESOLUTION_UNIT, tiffMetadata);
                exposure = (RationalNumber)ExifUtils.getTiffTagValue(TiffConstants.EXIF_TAG_EXPOSURE_TIME, tiffMetadata);
                exposureProgram = ExifUtils.getTiffExposureProgram((Integer)ExifUtils.getTiffTagValue(TiffConstants.EXIF_TAG_EXPOSURE_PROGRAM, tiffMetadata));
                fStop = (RationalNumber)ExifUtils.getTiffTagValue(TiffConstants.EXIF_TAG_FNUMBER, tiffMetadata);
                dateDigitized = (String)ExifUtils.getTiffTagValue(TiffConstants.EXIF_TAG_DATE_TIME_ORIGINAL, tiffMetadata);
                dateOriginal = (String)ExifUtils.getTiffTagValue(TiffConstants.EXIF_TAG_CREATE_DATE, tiffMetadata);
                flash = ExifUtils.getTiffFlash((Integer)ExifUtils.getTiffTagValue(TiffConstants.EXIF_TAG_FLASH, tiffMetadata));
                focalLength = (RationalNumber)ExifUtils.getTiffTagValue(TiffConstants.EXIF_TAG_FOCAL_LENGTH, tiffMetadata);
                colorSpace = ExifUtils.getTiffColorSpace((Integer)ExifUtils.getTiffTagValue(TiffConstants.EXIF_TAG_COLOR_SPACE, tiffMetadata));
                pixelXDimension = (Integer)ExifUtils.getTiffTagValue(TiffConstants.EXIF_TAG_EXIF_IMAGE_WIDTH, tiffMetadata);
                pixelYDimension = (Integer)ExifUtils.getTiffTagValue(TiffConstants.EXIF_TAG_EXIF_IMAGE_LENGTH, tiffMetadata);
                ISO = (Integer)ExifUtils.getTiffTagValue(TiffConstants.EXIF_TAG_ISO, tiffMetadata);
            } else if (metadata instanceof JpegImageMetadata) {
                JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
                imageDescription = (String)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_IMAGE_DESCRIPTION, jpegMetadata);
                userComment = (String)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_USER_COMMENT, jpegMetadata);
                copyright = (String)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_COPYRIGHT, jpegMetadata);
                artist = (String)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_ARTIST, jpegMetadata);
                manufacturer = (String)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_MAKE, jpegMetadata);
                model = (String)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_MODEL, jpegMetadata);
                compression = ExifUtils.getExifCompressionName((Integer)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_COMPRESSION, jpegMetadata));
                xResolution = (RationalNumber)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_XRESOLUTION, jpegMetadata);
                yResolution = (RationalNumber)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_YRESOLUTION, jpegMetadata);
                resolutionUnit = (Integer)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_RESOLUTION_UNIT, jpegMetadata);
                exposure = (RationalNumber)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_EXPOSURE_TIME, jpegMetadata);
                exposureProgram = ExifUtils.getExifExposureProgram((Integer)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_EXPOSURE_PROGRAM, jpegMetadata));
                fStop = (RationalNumber)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_FNUMBER, jpegMetadata);
                dateDigitized = (String)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL, jpegMetadata);
                dateOriginal = (String)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_CREATE_DATE, jpegMetadata);
                flash = ExifUtils.getExifFlash((Integer)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_FLASH, jpegMetadata));
                focalLength = (RationalNumber)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_FOCAL_LENGTH, jpegMetadata);
                colorSpace = ExifUtils.getExifColorSpace((Integer)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_COLOR_SPACE, jpegMetadata));
                pixelXDimension = (Integer)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_EXIF_IMAGE_WIDTH, jpegMetadata);
                pixelYDimension = (Integer)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_EXIF_IMAGE_LENGTH, jpegMetadata);
                ISO = (Integer)ExifUtils.getExifTagValue(ExifTagConstants.EXIF_TAG_ISO, jpegMetadata);
            } else {
                return null;
            }
            ExifData data = new ExifData();
            if (imageDescription != null || userComment != null) {
                if (imageDescription != null && userComment != null) {
                    String value;
                    imageDescription = imageDescription.trim();
                    String string = value = (userComment = userComment.trim()).length() > imageDescription.length() ? userComment : imageDescription;
                    if (ExifUtils.containsHtmlEntities(value)) {
                        value = StringEscapeUtils.unescapeHtml4((String)value);
                    }
                    data.setDescription(value);
                } else if (imageDescription != null) {
                    if (ExifUtils.containsHtmlEntities(imageDescription = imageDescription.trim())) {
                        imageDescription = StringEscapeUtils.unescapeHtml4((String)imageDescription);
                    }
                    data.setDescription(imageDescription);
                } else {
                    if (ExifUtils.containsHtmlEntities(userComment = userComment.trim())) {
                        userComment = StringEscapeUtils.unescapeHtml4((String)userComment);
                    }
                    data.setDescription(userComment);
                }
            }
            if (copyright != null) {
                if (ExifUtils.containsHtmlEntities(copyright = copyright.trim())) {
                    copyright = StringEscapeUtils.unescapeHtml4((String)copyright);
                }
                data.setCopyright(copyright);
            }
            if (artist != null) {
                if (ExifUtils.containsHtmlEntities(artist = artist.trim())) {
                    artist = StringEscapeUtils.unescapeHtml4((String)artist);
                }
                data.setArtist(artist);
            }
            if (xResolution != null && xResolution.intValue() > 0) {
                data.setxResolution(xResolution.intValue());
            }
            if (yResolution != null && yResolution.intValue() > 0) {
                data.setyResolution(xResolution.intValue());
            }
            if (StringUtils.isNotBlank((CharSequence)manufacturer)) {
                if (ExifUtils.containsHtmlEntities(manufacturer = manufacturer.trim())) {
                    manufacturer = StringEscapeUtils.unescapeHtml4((String)manufacturer);
                }
                data.setManufacturer(manufacturer);
            }
            if (StringUtils.isNotBlank((CharSequence)model)) {
                if (ExifUtils.containsHtmlEntities(model = model.trim())) {
                    model = StringEscapeUtils.unescapeHtml4((String)model);
                }
                data.setModel(model);
            }
            data.setCompression(compression);
            data.setResolutionUnit(resolutionUnit);
            data.setExposure(exposure);
            data.setExposureProgram(exposureProgram);
            data.setfStop(fStop);
            dateDigitized = StringUtils.trimToNull((String)dateDigitized);
            if (dateDigitized != null) {
                tmpDate = null;
                try {
                    tmpDate = tiffExifDateFormat.parseDateTime(dateDigitized).toDate();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                data.setDateDigitized(tmpDate);
            }
            if ((dateOriginal = StringUtils.trimToNull((String)dateOriginal)) != null) {
                tmpDate = null;
                try {
                    tmpDate = tiffExifDateFormat.parseDateTime(dateOriginal).toDate();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                data.setDateOriginal(tmpDate);
            }
            data.setFlash(flash);
            data.setFocalLength(focalLength);
            data.setColorSpace(colorSpace);
            data.setPixelXDimension(pixelXDimension);
            data.setPixelYDimension(pixelYDimension);
            data.setISO(ISO);
            return data;
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String getTiffCompressionName(Integer compressionValue) {
        if (compressionValue == null) {
            return null;
        }
        String compressionName = null;
        switch (compressionValue) {
            case 2: {
                compressionName = "CCITT 1D";
                break;
            }
            case 3: {
                compressionName = "T4 GROUP 3 FAX";
                break;
            }
            case 4: {
                compressionName = "T6 GROUP 4 FAX";
                break;
            }
            case 5: {
                compressionName = "LZW";
                break;
            }
            case 6: {
                compressionName = "JPEG OLD STYLE";
                break;
            }
            case 7: {
                compressionName = "JPEG";
                break;
            }
            case 8: {
                compressionName = "ADOBE DEFLATE";
                break;
            }
            case 9: {
                compressionName = "JBIG B AND W";
                break;
            }
            case 10: {
                compressionName = "JBIG COLOR";
                break;
            }
            case 32766: {
                compressionName = "NEXT";
                break;
            }
            case 32769: {
                compressionName = "EPSON ERF COMPRESSED";
                break;
            }
            case 32771: {
                compressionName = "CCIRLEW";
                break;
            }
            case 32773: {
                compressionName = "PACK BITS";
                break;
            }
            case 32895: {
                compressionName = "IT8CTPAD";
                break;
            }
            case 32896: {
                compressionName = "IT8LW";
                break;
            }
            case 32897: {
                compressionName = "IT8MP";
                break;
            }
            case 32898: {
                compressionName = "IT8BL";
                break;
            }
            case 32908: {
                compressionName = "PIXAR FILM";
                break;
            }
            case 32909: {
                compressionName = "PIXAR LOG";
                break;
            }
            case 32946: {
                compressionName = "DEFLATE";
                break;
            }
            case 32947: {
                compressionName = "DCS";
                break;
            }
            case 34661: {
                compressionName = "JBIG";
                break;
            }
            case 34676: {
                compressionName = "SGILOG";
                break;
            }
            case 34677: {
                compressionName = "SGILOG 24";
                break;
            }
            case 34712: {
                compressionName = "JPEG 2000";
                break;
            }
            case 34713: {
                compressionName = "NIKON NEF COMPRESSED";
                break;
            }
            case 65000: {
                compressionName = "KODAK DCR COMPRESSED";
                break;
            }
            case 65535: {
                compressionName = "PENTAX PEF COMPRESSED";
                break;
            }
            case 32809: {
                compressionName = "THUNDERSCAN";
            }
        }
        return compressionName;
    }

    public static Flash getTiffFlash(Integer flashValue) {
        Flash flash = null == flashValue ? Flash.NOT_FIRED : (flashValue == 1 || flashValue == 5 || flashValue == 7 || flashValue == 9 || flashValue == 13 || flashValue == 15 || flashValue == 25 || flashValue == 29 || flashValue == 31 ? Flash.FIRED : (flashValue == 65 || flashValue == 71 || flashValue == 69 || flashValue == 89 || flashValue == 93 || flashValue == 95 || flashValue == 73 || flashValue == 77 || flashValue == 79 ? Flash.FIRED_WITH_RED_EYES_REDUCTION : Flash.NOT_FIRED));
        return flash;
    }

    public static String getTiffExposureProgram(Integer exposureProgramValue) {
        if (exposureProgramValue == null || exposureProgramValue == 0) {
            return null;
        }
        switch (exposureProgramValue) {
            case 2: {
                return "Program AE";
            }
            case 3: {
                return "Aperture priority AE";
            }
            case 4: {
                return "Shutter speed priority AE";
            }
            case 5: {
                return "Creative slow speed";
            }
            case 6: {
                return "Action high speed";
            }
            case 7: {
                return "Portrait";
            }
            case 8: {
                return "Landscape";
            }
        }
        return null;
    }

    public static String getTiffColorSpace(Integer colorSpaceValue) {
        if (colorSpaceValue == null) {
            return null;
        }
        switch (colorSpaceValue) {
            case 2: {
                return "Adobe RGB";
            }
        }
        return "sRGB";
    }

    public static String getExifCompressionName(Integer compressionValue) {
        if (compressionValue == null) {
            return null;
        }
        String compressionName = null;
        switch (compressionValue) {
            case 2: {
                compressionName = "CCITT 1D";
                break;
            }
            case 3: {
                compressionName = "T4 GROUP 3 FAX";
                break;
            }
            case 4: {
                compressionName = "T6 GROUP 4 FAX";
                break;
            }
            case 5: {
                compressionName = "LZW";
                break;
            }
            case 6: {
                compressionName = "JPEG OLD STYLE";
                break;
            }
            case 7: {
                compressionName = "JPEG";
                break;
            }
            case 8: {
                compressionName = "ADOBE DEFLATE";
                break;
            }
            case 9: {
                compressionName = "JBIG B AND W";
                break;
            }
            case 10: {
                compressionName = "JBIG COLOR";
                break;
            }
            case 32766: {
                compressionName = "NEXT";
                break;
            }
            case 32769: {
                compressionName = "EPSON ERF COMPRESSED";
                break;
            }
            case 32771: {
                compressionName = "CCIRLEW";
                break;
            }
            case 32773: {
                compressionName = "PACK BITS";
                break;
            }
            case 32895: {
                compressionName = "IT8CTPAD";
                break;
            }
            case 32896: {
                compressionName = "IT8LW";
                break;
            }
            case 32897: {
                compressionName = "IT8MP";
                break;
            }
            case 32898: {
                compressionName = "IT8BL";
                break;
            }
            case 32908: {
                compressionName = "PIXAR FILM";
                break;
            }
            case 32909: {
                compressionName = "PIXAR LOG";
                break;
            }
            case 32946: {
                compressionName = "DEFLATE";
                break;
            }
            case 32947: {
                compressionName = "DCS";
                break;
            }
            case 34661: {
                compressionName = "JBIG";
                break;
            }
            case 34676: {
                compressionName = "SGILOG";
                break;
            }
            case 34677: {
                compressionName = "SGILOG 24";
                break;
            }
            case 34712: {
                compressionName = "JPEG 2000";
                break;
            }
            case 34713: {
                compressionName = "NIKON NEF COMPRESSED";
                break;
            }
            case 65000: {
                compressionName = "KODAK DCR COMPRESSED";
                break;
            }
            case 65535: {
                compressionName = "PENTAX PEF COMPRESSED";
                break;
            }
            case 32809: {
                compressionName = "THUNDERSCAN";
            }
        }
        return compressionName;
    }

    public static Flash getExifFlash(Integer flashValue) {
        Flash flash = null == flashValue ? Flash.NOT_FIRED : (flashValue == 1 || flashValue == 5 || flashValue == 7 || flashValue == 9 || flashValue == 13 || flashValue == 15 || flashValue == 25 || flashValue == 29 || flashValue == 31 ? Flash.FIRED : (flashValue == 65 || flashValue == 71 || flashValue == 69 || flashValue == 89 || flashValue == 93 || flashValue == 95 || flashValue == 73 || flashValue == 77 || flashValue == 79 ? Flash.FIRED_WITH_RED_EYES_REDUCTION : Flash.NOT_FIRED));
        return flash;
    }

    public static String getExifExposureProgram(Integer exposureProgramValue) {
        if (exposureProgramValue == null || exposureProgramValue == 0) {
            return null;
        }
        switch (exposureProgramValue) {
            case 2: {
                return "Normal Program";
            }
            case 3: {
                return "Aperture priority";
            }
            case 4: {
                return "Shutter priority";
            }
            case 5: {
                return "Creative program";
            }
            case 6: {
                return "Action program";
            }
            case 7: {
                return "Portrait mode";
            }
            case 8: {
                return "Landscape mode";
            }
        }
        return null;
    }

    public static String getExifColorSpace(Integer colorSpaceValue) {
        if (colorSpaceValue == null) {
            return null;
        }
        switch (colorSpaceValue) {
            case 2: {
                return "Adobe RGB";
            }
        }
        return "sRGB";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeExifData(File input, ExifData data, File output) {
        boolean bl;
        String copyright;
        String artist;
        JpegImageMetadata jpegMetadata;
        TiffImageMetadata exif;
        TiffOutputSet outputSet = null;
        IImageMetadata metadata = Sanselan.getMetadata((File)input);
        if (metadata != null && metadata instanceof JpegImageMetadata && (exif = (jpegMetadata = (JpegImageMetadata)metadata).getExif()) != null) {
            outputSet = exif.getOutputSet();
        }
        if (outputSet == null) {
            outputSet = new TiffOutputSet();
        }
        ExifUtils.removeTagIfExists(ExifTagConstants.EXIF_TAG_IMAGE_DESCRIPTION, outputSet);
        ExifUtils.removeTagIfExists(ExifTagConstants.EXIF_TAG_USER_COMMENT, outputSet);
        ExifUtils.removeTagIfExists(ExifTagConstants.EXIF_TAG_ARTIST, outputSet);
        ExifUtils.removeTagIfExists(ExifTagConstants.EXIF_TAG_COPYRIGHT, outputSet);
        String description = data.getDescription();
        if (description != null) {
            ExifUtils.addAsciiTag(ExifTagConstants.EXIF_TAG_IMAGE_DESCRIPTION, description, outputSet);
            ExifUtils.addAsciiTag(ExifTagConstants.EXIF_TAG_USER_COMMENT, description, outputSet);
        }
        if ((artist = data.getArtist()) != null) {
            ExifUtils.addAsciiTag(ExifTagConstants.EXIF_TAG_ARTIST, artist, outputSet);
        }
        if ((copyright = data.getCopyright()) != null) {
            ExifUtils.addAsciiTag(ExifTagConstants.EXIF_TAG_COPYRIGHT, copyright, outputSet);
        }
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(output));
            new ExifRewriter().updateExifMetadataLossless(input, (OutputStream)outputStream, outputSet);
            ((OutputStream)outputStream).flush();
            bl = true;
        }
        catch (Exception ex) {
            boolean bl2;
            try {
                log.warn((Object)ex.getMessage(), (Throwable)ex);
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
                catch (Exception ex2) {
                    log.warn((Object)ex2.getMessage(), (Throwable)ex2);
                    return false;
                }
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            return bl2;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return bl;
    }

    private static void addAsciiTag(TagInfo tagInfo, String tagValue, TiffOutputSet outputSet) {
        try {
            FieldTypeASCII fieldType = TiffFieldTypeConstants.FIELD_TYPE_ASCII;
            byte[] bytes = fieldType.writeData((Object)tagValue, outputSet.byteOrder);
            TiffOutputField outputField = new TiffOutputField(tagInfo.tag, tagInfo, (FieldType)fieldType, tagValue.length(), bytes);
            outputSet.getOrCreateExifDirectory().add(outputField);
            outputSet.getOrCreateRootDirectory().add(outputField);
        }
        catch (ImageWriteException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void removeTagIfExists(TagInfo tagInfo, TiffOutputSet outputSet) {
        if (outputSet.findField(tagInfo) != null) {
            outputSet.removeField(tagInfo);
        }
    }

    private static <T> T getTiffTagValue(TagInfo tagInfo, TiffImageMetadata metadata) {
        try {
            TiffField field = metadata.findField(tagInfo);
            if (field != null) {
                return (T)field.getValue();
            }
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private static <T> T getExifTagValue(TagInfo tagInfo, JpegImageMetadata metadata) {
        try {
            TiffField field = metadata.findEXIFValue(tagInfo);
            if (field != null) {
                return (T)field.getValue();
            }
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private static boolean containsHtmlEntities(String value) {
        return value != null && HTML_ENTITY_PATTERN.matcher(value).find();
    }

    private ExifUtils() {
    }
}

