/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.filter;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;

public class Filters {
    private static final int MAXIMUM_LENGTH = 255;
    private static SubDirectoriesFileFilter subDirectoriesFileFilter;

    private Filters() {
    }

    public static SubDirectoriesFileFilter subDirectoriesFileFilter() {
        if (subDirectoriesFileFilter == null) {
            subDirectoriesFileFilter = new SubDirectoriesFileFilter();
        }
        return subDirectoriesFileFilter;
    }

    public static SubDirsNotUsersFolderFileFilter subDirsNotUsersFolderFileFilter(String usersFolder) {
        return new SubDirsNotUsersFolderFileFilter(usersFolder);
    }

    private static boolean isValidDirectory(File file) {
        return file.isDirectory() && file.getName().length() <= 255;
    }

    private static class SubDirsNotUsersFolderFileFilter
    implements FileFilter,
    Serializable {
        private static final long serialVersionUID = 3743386882249643099L;
        private String usersFolder;

        private SubDirsNotUsersFolderFileFilter(String usersFolder) {
            this.usersFolder = usersFolder;
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return Filters.isValidDirectory(file) && !name.equals(this.usersFolder);
        }
    }

    private static class SubDirectoriesFileFilter
    implements FileFilter,
    Serializable {
        private static final long serialVersionUID = -2938856979035138347L;

        private SubDirectoriesFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return Filters.isValidDirectory(file);
        }
    }
}

