package com.imcode.imcms.addon.imagearchive.service;

import com.imcode.imcms.addon.imagearchive.dto.LibraryRolesDto;
import com.imcode.imcms.addon.imagearchive.entity.LibraryRoles;
import com.imcode.imcms.addon.imagearchive.entity.User;

import java.util.Collection;

/**
 * @author Serhii from Ubrainians for Imcode
 *         10.10.16
 */
public interface LibraryRolesService {
    Collection<LibraryRoles> findLibraryRolesByLibraryId(long id);

    Collection<LibraryRolesDto> findLibraryRolesDtoByLibraryId(long id);

    void delete(LibraryRoles libraryRoles);

    void delete(Iterable<LibraryRoles> libraryRoles);

    Collection<LibraryRoles> findAll();

    void updateLibraryRoles(long id, String libraryNm, Collection<LibraryRolesDto> libraryRoles);

    boolean canUserUseLibrary(long libraryId, User user);
}
