package com.imcode.imcms.addon.imagearchive.service;

import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import com.imcode.imcms.addon.imagearchive.dto.LibraryEntryDto;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.file.LibrarySort;
import com.imcode.imcms.addon.imagearchive.service.file.ThumbSize;

import java.io.File;
import java.io.FileFilter;
import java.util.List;

public interface FileService {
    File createTemporaryFile(String prefix);

    boolean deleteTemporaryFile(File prefix);

    File getImageRootPath(long imageId);

    File getImageFile(long imageId, String infix, boolean temporary);

    File getImageOriginalFile(long imageId, boolean temporary);

    File getImageFullFile(long imageId, boolean temporary);

    boolean storeImage(File tempFile, long imageId, boolean temporary);

    void rotateImage(long imageId, int angle, boolean temporary);

    void copyTemporaryImageToCurrent(long imageId);

    void createTemporaryCopyOfCurrentImage(long imageId);

    void deleteTemporaryImage(long imageId);

    void deleteImage(long imageId);

    Object[] getImageThumbnail(long imageId, ThumbSize thumbSize, boolean temporary);

//    public Object[] getImageFull(long imageId, boolean temporary);

    List<File> getSubdirs(File file, FileFilter filter);

    List<File> listFirstLevelLibraryFolders();

    List<File> listLibraryFolders();

    List<LibraryEntryDto> listLibraryEntries(LibrariesDto library, User user, LibrarySort sortBy);

    /* Now used exclusively with user personal library */
    boolean storeImageToLibrary(LibrariesDto library, File tempFile, String fileName);

    boolean storeZipToLibrary(LibrariesDto library, File tempFile);

    void deleteFileFromLibrary(LibrariesDto library, String fileName);

    File getImageFileFromLibrary(LibrariesDto library, String fileName);

    byte[] getThumbnail(long imageId, ThumbSize thumbSize, boolean temporary);

}
