package com.imcode.imcms.addon.imagearchive.filter;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;

/**
 * Holds file filters
 *
 * @author Serhii from Ubrainians for Imcode
 *         13.10.16
 */
public class Filters {
    private static final int MAXIMUM_LENGTH = 255;
    private static SubDirectoriesFileFilter subDirectoriesFileFilter;

    private Filters() {
    }

    public static SubDirectoriesFileFilter subDirectoriesFileFilter() {
        if (subDirectoriesFileFilter == null) {
            subDirectoriesFileFilter = new SubDirectoriesFileFilter();
        }
        return subDirectoriesFileFilter;
    }

    public static SubDirsNotUsersFolderFileFilter subDirsNotUsersFolderFileFilter(String usersFolder) {
        return new SubDirsNotUsersFolderFileFilter(usersFolder);
    }

    private static boolean isValidDirectory(File file) {
        return (file.isDirectory() && (file.getName().length() <= MAXIMUM_LENGTH));
    }

    private static class SubDirectoriesFileFilter implements FileFilter, Serializable {
        private static final long serialVersionUID = -2938856979035138347L;

        public boolean accept(File file) {
            return isValidDirectory(file);
        }
    }

    private static class SubDirsNotUsersFolderFileFilter implements FileFilter, Serializable {
        private static final long serialVersionUID = 3743386882249643099L;
        private String usersFolder;

        private SubDirsNotUsersFolderFileFilter(String usersFolder) {
            this.usersFolder = usersFolder;
        }

        public boolean accept(File file) {
            String name = file.getName();

            return (isValidDirectory(file) && !name.equals(usersFolder));
        }
    }
}
