package com.imcode.imcms.addon.imagearchive.entity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@SuppressWarnings("unused")
@Entity
@Table(name = "archive_library_roles")
@IdClass(LibraryRolesPK.class)
public class LibraryRoles implements Serializable {

	private static final long serialVersionUID = 7183874632512318668L;

	@Id
	@Column(name="library_id", nullable = false)
	private long libraryId;

	@Id
	@Column(name = "role_id", nullable = false)
	private int roleId;

	@Column(name = "permissions", nullable = false)
	private int permissions;

	@Column(name = "created_dt", nullable = false)
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "updated_dt", nullable = false)
	@Temporal(TemporalType.TIMESTAMP)
	private Date updatedDate;

	@Column(name = "canUse", nullable = false)
	private Boolean canUse;

	@Column(name = "canChange", nullable = false)
	private Boolean canChange;

	public LibraryRoles() {
	}

	public int getRoleId() {
		return roleId;
	}

	public void setRoleId(int roleId) {
		this.roleId = roleId;
	}

	public int getPermissions() {
		return permissions;
	}

	public void setPermissions(int permissions) {
		this.permissions = permissions;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getUpdatedDate() {
		return updatedDate;
	}

	public void setUpdatedDate(Date updatedDate) {
		this.updatedDate = updatedDate;
	}

	public Boolean getCanUse() {
		return canUse;
	}

	public void setCanUse(Boolean canUse) {
		this.canUse = canUse;
	}

	public Boolean getCanChange() {
		return canChange;
	}

	public void setCanChange(Boolean canChange) {
		this.canChange = canChange;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}

		if (getClass() != obj.getClass()) {
			return false;
		}

		final LibraryRoles other = (LibraryRoles) obj;
		if (this.libraryId != other.libraryId) {
			return false;
		}

		return this.roleId == other.roleId;
	}

	@Override
	public int hashCode() {
		int hash = 3;
		hash = 48 * hash + ((int) this.libraryId) + 33 * hash + this.roleId;

		return hash;
	}

	@Override
	public String toString() {
		return String.format("com.imcode.imcms.addon.imagearchive.entity.LibraryRoles[libraryId: %d, roleId: %d]",
				libraryId, roleId);
	}

	public long getLibraryId() {
		return libraryId;
	}

	public void setLibraryId(long libraryId) {
		this.libraryId = libraryId;
	}
}
