/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.command;

import com.imcode.imcms.addon.imagearchive.entity.Exif;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ImageData
implements Serializable {
    private byte[] bytes;
    private String fileName;
    private int fileCount;
    private String imageNm;
    private String description;
    private String categories;
    private String keywords;
    private String imageKeywords;
    private String artist;
    private String uploadedBy;
    private String copyright;
    private String licenseDt;
    private String licenseEndDt;
    private boolean changedFile;
    private int rotation = 0;
    private Date licenseDate;
    private Date licenseEndDate;
    private String altText;
    private List<Long> categoryIds = new ArrayList<Long>();
    private List<String> keywordNames = new ArrayList<String>();

    public void fromImage(Image image) {
        Exif exif = image.getExif();
        this.artist = exif.getArtist();
        this.copyright = exif.getCopyright();
        this.description = exif.getDescription();
        this.imageNm = image.getName();
        this.uploadedBy = image.getUploadedBy();
        this.altText = image.getAltText();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (image.getLicenseDt() != null) {
            this.licenseDt = df.format(image.getLicenseDt());
        }
        if (image.getLicenseEndDt() != null) {
            this.licenseEndDt = df.format(image.getLicenseEndDt());
        }
    }

    public void toImage(Image image) {
        String newDescription = StringUtils.trimToEmpty((String)this.description);
        String newArtist = StringUtils.trimToEmpty((String)this.artist);
        String newCopyright = StringUtils.trimToEmpty((String)this.copyright);
        Exif exif = image.getExif();
        if (!newDescription.isEmpty()) {
            exif.setDescription(newDescription);
        }
        if (!newArtist.isEmpty()) {
            exif.setArtist(newArtist);
        }
        exif.setCopyright(newCopyright);
        image.setName(StringUtils.trimToEmpty((String)this.imageNm));
        image.setUploadedBy(StringUtils.trimToEmpty((String)this.uploadedBy));
        image.setLicenseDt(this.licenseDate);
        image.setLicenseEndDt(this.licenseEndDate);
        image.setAltText(this.altText);
    }
}

