package com.imcode.imcms.addon.imagearchive.entity;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import java.io.Serializable;

/**
 * @author Serhii from Ubrainians for Imcode
 *         12.10.16
 */
@Embeddable
public class LibraryRolesPK implements Serializable {

    private static final long serialVersionUID = -3686984251749283015L;

    @Column(name = "library_id", nullable = false)
    private long libraryId;

    @Column(name = "role_id", nullable = false)
    private int roleId;

    public LibraryRolesPK() {
    }

    public LibraryRolesPK(long libraryId, int roleId) {
        this.libraryId = libraryId;
        this.roleId = roleId;
    }

    public long getLibraryId() {
        return libraryId;
    }

    public void setLibraryId(long libraryId) {
        this.libraryId = libraryId;
    }

    public int getRoleId() {
        return roleId;
    }

    public void setRoleId(int roleId) {
        this.roleId = roleId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LibraryRolesPK)) return false;

        LibraryRolesPK that = (LibraryRolesPK) o;

        if (libraryId != that.libraryId) return false;
        return roleId == that.roleId;
    }

    @Override
    public int hashCode() {
        int result = (int) libraryId;
        result = 31 * result + roleId;
        return result;
    }

    @Override
    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.LibraryRolesPK[libraryId: %d, roleId: %d]",
                libraryId, roleId);
    }
}
