package com.imcode.imcms.addon.imagearchive.service;

import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import com.imcode.imcms.addon.imagearchive.dto.LibraryRolesDto;
import com.imcode.imcms.addon.imagearchive.entity.Library;
import com.imcode.imcms.addon.imagearchive.entity.Role;

import java.util.Collection;
import java.util.List;

public interface LibraryService {
    Library findLibraryById(final Long libraryId);

    void syncLibraryFolders();

    List<Library> getAllLibraries();

    List<LibraryRolesDto> findLibraryRoles(final Long libraryId);

    void updateLibraryRoles(final int libraryId, final String libraryNm, final List<LibraryRolesDto> libraryRoles);

    List<LibrariesDto> librariesToDto(List<Library> libraries);

    LibrariesDto convertToLibraryDto(Library library);

    LibrariesDto findLibraryDtoById(Long id);

    List<LibrariesDto> findLibraryDtos();

    Collection<Role> getAllRoles();
}
