package com.imcode.imcms.addon.imagearchive.entity;

import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Entity
@Table(name = "archive_keywords")
public class Keyword implements Serializable, Comparable<Keyword> {
    private static final long serialVersionUID = -5618267783578349726L;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue
    private Long id;

    @Column(name = "keyword_nm", length = 50, nullable = false)
    private String name;

    @Column(name = "created_dt", nullable = false)
    @Temporal(TemporalType.TIMESTAMP)
    private Date createdDt = new Date();

    @ManyToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    @LazyCollection(LazyCollectionOption.TRUE)
    @JoinTable(
            name = "archive_image_keywords",
            inverseJoinColumns = @JoinColumn(name = "image_id", nullable = false),
            joinColumns = @JoinColumn(name = "keyword_id", nullable = false)
    )
    private List<Image> images;


    public Keyword() {
    }

    public Keyword(String name) {
        this.name = name;
    }

    @PrePersist
    public void prePersist() {
        createdDt = new Date();
    }

    public Date getCreatedDt() {
        return createdDt;
    }

    public void setCreatedDt(Date createdDt) {
        this.createdDt = createdDt;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }


    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        final Keyword other = (Keyword) obj;
        return this.id == other.id;

    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (int) (this.id ^ (this.id >>> 32));

        return hash;
    }

    @Override
    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.Keywords[id: %d, name: %s]",
                id, name);
    }

    public int compareTo(Keyword o) {
        return this.id.compareTo(o.id);
    }

    public List<Image> getImages() {
        return images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }
}
