package com.imcode.imcms.addon.imagearchive.tag.func;

import com.imcode.imcms.addon.imagearchive.dto.LibraryEntryDto;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import org.apache.commons.lang3.StringUtils;
import org.apache.sanselan.common.RationalNumber;
import org.apache.sanselan.common.RationalNumberUtilities;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.jsp.PageContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class Functions {

    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\r\n?");


    public static boolean isInArchive(LibraryEntryDto img, PageContext pageContext) {
        if(img == null) {
            return false;
        }

        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext(pageContext.getServletContext());
        Facade facade = (Facade) context.getBean("facade");

        List<Image> archiveImages = facade.getImageService().getAllImages();
        for (Image image : archiveImages) {
            if (image.getName().equals(img.getFileName()) && image.getFileSize() == img.getFileSize()) {
                return true;
            }
        }

        return false;
    }

    public static String newlineToBr(String value) {
        if (value == null) {
            return null;
        } else {
            return NEWLINE_PATTERN.matcher(value).replaceAll("<br/>");
        }
    }

    public static String abbreviate(String str, int maxWidth) {
        return StringUtils.abbreviate(str, maxWidth);
    }

    public static <T> String join(Collection<T> elements, String separator) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }

        StringBuilder builder = new StringBuilder();

        Iterator<T> it = elements.iterator();
        while (it.hasNext()) {
            builder.append(it.next());

            if (it.hasNext()) {
                builder.append(separator);
            }
        }

        return builder.toString();
    }

    public static String doubleToFractionsString(Double number) {
        if(number == null) {
            return null;
        }

        RationalNumber rationalNumber = RationalNumberUtilities.getRationalNumber(number);
        return rationalNumber.numerator + "/" + rationalNumber.divisor;
    }
}
