package com.imcode.imcms.addon.imagearchive.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Entity
@Table(name = "archive_images")
public class Image implements Serializable {
	public static final short STATUS_UPLOADED = 0;
	public static final short STATUS_ACTIVE = 1;
	public static final short STATUS_ARCHIVED = 2;
	private static final long serialVersionUID = -1831641612874730366L;
	@Id
	@GeneratedValue
	private Long id;

	@Column(name = "image_nm", length = 255, nullable = false)
	private String name = "";

	@Column(name = "format", nullable = false)
	private short format;

	@Column(name = "width", nullable = false)
	private int width;

	@Column(name = "height", nullable = false)
	private int height;

	@Column(name = "file_size", nullable = false)
	private int fileSize;

	@Column(name = "uploaded_by", length = 130, nullable = false)
	private String uploadedBy = "";

	@Column(name = "status", nullable = false)
	private short status = STATUS_UPLOADED;

	@Column(name = "created_dt", nullable = false)
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDt = new Date();

	@Column(name = "updated_dt", nullable = false)
	@Temporal(TemporalType.TIMESTAMP)
	private Date updatedDt = new Date();

	@Column(name = "license_dt")
	@Temporal(TemporalType.DATE)
	private Date licenseDt;

	@Column(name = "license_end_dt")
	@Temporal(TemporalType.DATE)
	private Date licenseEndDt;

	@Column(name = "alt_text")
	private String altText;

	@ManyToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	@JoinTable(
			name = "image_categories",
			joinColumns = @JoinColumn(name = "image_id", nullable = false),
			inverseJoinColumns = @JoinColumn(name = "category_id", nullable = false)
	)
	private List<Category> categories;

	@ManyToMany(cascade = CascadeType.ALL)
	@LazyCollection(LazyCollectionOption.FALSE)
	@JoinTable(
			name = "archive_image_keywords",
			joinColumns = @JoinColumn(name = "image_id", nullable = false, insertable = false, updatable = false),
			inverseJoinColumns = @JoinColumn(name = "keyword_id", nullable = false, insertable = false, updatable = false)
	)
	private List<Keyword> keywords;

	@OneToOne(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	@JoinColumn(name = "exif_id")
	private Exif exif;

	@Transient
	private boolean canChange;

	public Image() {
	}

	public int getFileSize() {
		return fileSize;
	}

	public void setFileSize(int fileSize) {
		this.fileSize = fileSize;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Date getCreatedDt() {
		return createdDt;
	}

	public void setCreatedDt(Date createdDt) {
		this.createdDt = createdDt;
	}

	public String getAltText() {
		return altText;
	}

	public void setAltText(String altText) {
		this.altText = altText;
	}

	public String getUploadedBy() {
		return uploadedBy;
	}

	public void setUploadedBy(String uploadedBy) {
		this.uploadedBy = uploadedBy;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public short getFormat() {
		return format;
	}

	public void setFormat(short format) {
		this.format = format;
	}

	public Date getLicenseDt() {
		return licenseDt;
	}

	public void setLicenseDt(Date licenseDt) {
		this.licenseDt = licenseDt;
	}

	public Date getLicenseEndDt() {
		return licenseEndDt;
	}

	public void setLicenseEndDt(Date licenseEndDt) {
		this.licenseEndDt = licenseEndDt;
	}

	public short getStatus() {
		return status;
	}

	public void setStatus(short status) {
		this.status = status;
	}

	public Date getUpdatedDt() {
		return updatedDt;
	}

	public void setUpdatedDt(Date updatedDt) {
		this.updatedDt = updatedDt;
	}

	public List<Category> getCategories() {
		return categories;
	}

	public void setCategories(List<Category> categories) {
		this.categories = categories;
	}

	public List<Keyword> getKeywords() {
		return keywords;
	}

	public void setKeywords(List<Keyword> keywords) {
		this.keywords = keywords;
	}

//    public Exif getChangedExif() {
//        return changedExif;
//    }
//
//    public void setChangedExif(Exif changedExif) {
//        this.changedExif = changedExif;
//    }

	//    public Exif getOriginalExif() {
//        return originalExif;
//    }
//
//    public void setOriginalExif(Exif originalExif) {
//        this.originalExif = originalExif;
//    }
//
//    public void setArtist(String artist) {
//        changedExif = new Exif();
//        changedExif.setArtist(artist);
//    }

	@JsonIgnore
	public boolean isArchived() {
		return status == STATUS_ARCHIVED;
	}

	public boolean isCanChange() {
		return canChange;
	}

	public void setCanChange(boolean canChange) {
		this.canChange = canChange;
	}

	public Exif getExif() {
		return exif;
	}

	public void setExif(Exif exif) {
		this.exif = exif;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}

		if (getClass() != obj.getClass()) {
			return false;
		}

		final Image other = (Image) obj;
		return this.id == other.id;
	}

	@Override
	public int hashCode() {
		int hash = 7;
		hash = 41 * hash + (int) (this.id ^ (this.id >>> 32));

		return hash;
	}

	@Override
	public String toString() {
		return String.format("com.imcode.imcms.addon.imagearchive.entity.Images[id: %d, name: %s, uploadedBy: %s]",
				id, name, uploadedBy);
	}
}
