package com.imcode.imcms.addon.imagearchive.util;

import com.imcode.imcms.addon.imagearchive.command.SearchImageCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Keyword;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by vitaly on 28.04.15.
 */public class Model {
    public SearchImageCommand search;
    public List<Category> categories;
    public List<Keyword> keywords;
    public String artists;
    public Long imageCount;
    public List<Image> images;
    public Pagination pag;

    public Model() {
    }

    public boolean put(String key, Object value) {
        try {
            Field field = this.getClass().getDeclaredField(key);
            field.set(this, value);
        } catch (Exception e) {
            return false;
        }

        return true;
    }

    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashMap<String, Object>();

        try {
            Field[] fields = this.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; i++) {
                Field field = fields[i];
                Object value = field.get(this);
                if (value != null) {
                    map.put(field.getName(), value);
                }
            }
        } catch (Exception ignore) { }

        return map;
    }

    public SearchImageCommand getSearch() {
        return search;
    }

    public void setSearch(SearchImageCommand search) {
        this.search = search;
    }

    public List<Category> getCategories() {
        return categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public List<Keyword> getKeywords() {
        return keywords;
    }

    public void setKeywords(List<Keyword> keywords) {
        this.keywords = keywords;
    }

    public String getArtists() {
        return artists;
    }

    public void setArtists(String artists) {
        this.artists = artists;
    }

    public Long getImageCount() {
        return imageCount;
    }

    public void setImageCount(Long imageCount) {
        this.imageCount = imageCount;
    }

    public List<Image> getImages() {
        return images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public Pagination getPag() {
        return pag;
    }

    public void setPag(Pagination pag) {
        this.pag = pag;
    }
}
