package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.command.SaveRoleCategoriesCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.CategoryRoles;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.repository.CategoryRolesRepository;
import com.imcode.imcms.addon.imagearchive.repository.RoleRepository;
import com.imcode.imcms.addon.imagearchive.service.RoleService;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Service
@Transactional
public class RoleServiceImpl implements RoleService {
    private static final Log log = LogFactory.getLog(RoleService.class);
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private CategoryRolesRepository categoryRolesRepository;

    public List<Role> getRolesByCategoryId(int id) {
        List<CategoryRoles> categoryRolesList = categoryRolesRepository.findByCategoryId(id);
        List<Role> rolesResult = new ArrayList<Role>();
        for (CategoryRoles categoryRoles : categoryRolesList) {
            rolesResult.add(categoryRoles.getRole());
        }
        return rolesResult;
    }


    public List<Category> getUsableRoleCategories(Role role) {
        return getRoleCategories(role.getId(), true, false);
    }

    public List<Category> getUsableRoleCategories(Role... roles) {
        Set<Category> result = new HashSet<Category>();
        for (Role role : roles) {
            result.addAll(getRoleCategories(role.getId(), true, false));
        }
        return new ArrayList<Category>(result);
    }

    public List<Category> getUsableRoleCategories(int id) {
        return getRoleCategories(id, true, false);
    }

    public List<Category> getUsableRoleCategories(int... ids) {
        Set<Category> result = new HashSet<Category>();
        for (int id : ids) {
            result.addAll(getRoleCategories(id, true, false));
        }
        return new ArrayList<Category>(result);
    }

    public List<Category> getChangeableRoleCategories(int id) {
        return getRoleCategories(id, false, true);
    }

    public List<Category> getChangeableRoleCategories(int... ids) {
        Set<Category> result = new HashSet<Category>();
        for (int id : ids) {
            result.addAll(getRoleCategories(id, false, true));
        }
        return new ArrayList<Category>(result);
    }

    public List<Category> getChangeableRoleCategories(Role role) {
        return getRoleCategories(role.getId(), false, true);
    }

    public List<Category> getChangeableRoleCategories(Role... roles) {
        Set<Category> result = new HashSet<Category>();
        for (Role role : roles) {
            result.addAll(getRoleCategories(role.getId(), false, true));
        }
        return new ArrayList<Category>(result);
    }


    public List<Category> getAllRoleCategories(int id) {
        return getRoleCategories(id, false, false);
    }

    private List<Category> getRoleCategories(int id, boolean needUsable, boolean needChangable) {
        Set<Category> categoriesResult = new HashSet<Category>();
        List<CategoryRoles> categoryRolesList = categoryRolesRepository.findByRoleId(id);

        for (CategoryRoles categoryRoles : categoryRolesList) {
            if ((needUsable ? categoryRoles.getCanUse() : true) &&
                    (needChangable ? categoryRoles.getCanChange() : true)) {
                categoriesResult.add(Utils.getFacade().getCategoryService().getCategory(categoryRoles.getCategoryId()));
            }
        }
        return new ArrayList<Category>(categoriesResult);
    }

    public Role getRoleById(int roleId) {
        return roleRepository.findOne(roleId);
    }

    public Role getRoleByName(String name) {
        return roleRepository.findByName(name);
    }

    public List<Role> getAllRoles() {
        return roleRepository.findAll();
    }

    public List<CategoryRoles> getCategoryRolesByRole(Role role) {
        return categoryRolesRepository.findByRoleId(role.getId());
    }

    public void assignCategoryRoles(final Role role, final List<SaveRoleCategoriesCommand.CategoryRight> categoryRights) {

        List<CategoryRoles> toDelete = categoryRolesRepository.findByRoleId(role.getId());

        for (CategoryRoles categoryRole : toDelete) {
            categoryRolesRepository.delete(categoryRole);
        }
        categoryRolesRepository.flush();

        if (categoryRights != null) {
            for (SaveRoleCategoriesCommand.CategoryRight categoryRight : categoryRights) {
                CategoryRoles cr = new CategoryRoles(categoryRight.getCategoryId(), role.getId(), categoryRight.isCanUse(), categoryRight.isCanEditOrAdd());
                categoryRolesRepository.save(cr);
            }
        }
        categoryRolesRepository.flush();
    }
}
