package com.imcode.imcms.addon.imagearchive.service;

import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.service.exception.CategoryExistsException;

import java.util.Collection;
import java.util.List;

public interface CategoryService {

    boolean existsCategory(final String categoryName);

    Category createCategory(final String categoryName, final Integer typeId) throws CategoryExistsException;

    Category getCategory(final Long categoryId);

    List<Category> getCategories();

    void deleteCategory(final Long categoryId);

    void updateCategory(final Long categoryId, final String categoryName) throws CategoryExistsException;

    Category getCategory(final String name);

    Collection<Category> getCategories(Collection<Long> categoriesId);
}
