package com.imcode.imcms.addon.imagearchive.command;

import com.imcode.imcms.addon.imagearchive.entity.Exif;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by vitaly on 08.05.15.
 */
public class ImageData implements Serializable {
    private byte[] bytes;
    private String fileName;
    private int fileCount;
    private String imageNm;
    private String description;
    private String categories;
    private String keywords;
    private String imageKeywords;
    private String artist;
    private String uploadedBy;
    private String copyright;
    private String licenseDt;
    private String licenseEndDt;

    private boolean changedFile;
    private int rotation = 0;
    private Date licenseDate;
    private Date licenseEndDate;
    private String altText;
    private List<Long> categoryIds = new ArrayList<Long>();
    private List<String> keywordNames = new ArrayList<String>();
//    private List<String> imageKeywordNames = new ArrayList<String>();

    public void fromImage(Image image) {
//        Exif exif = image.getChangedExif();
        Exif exif = image.getExif();

        this.artist = exif.getArtist();
        this.copyright = exif.getCopyright();
        this.description = exif.getDescription();
        this.imageNm = image.getName();
        this.uploadedBy = image.getUploadedBy();
        this.altText = image.getAltText();

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

        if (image.getLicenseDt() != null) {
            this.licenseDt = df.format(image.getLicenseDt());
        }

        if (image.getLicenseEndDt() != null) {
            this.licenseEndDt = df.format(image.getLicenseEndDt());
        }
    }

    public void toImage(Image image) {
        String newDescription = StringUtils.trimToEmpty(description);
        String newArtist = StringUtils.trimToEmpty(artist);
        String newCopyright = StringUtils.trimToEmpty(copyright);
        Exif exif = image.getExif();

        if(!newDescription.isEmpty()) {
            exif.setDescription(newDescription);
        }
        if(!newArtist.isEmpty() ) {
            exif.setArtist(newArtist);
        }
            exif.setCopyright(newCopyright);

        image.setName(StringUtils.trimToEmpty(imageNm));
        image.setUploadedBy(StringUtils.trimToEmpty(uploadedBy));
        image.setLicenseDt(licenseDate);
        image.setLicenseEndDt(licenseEndDate);
        image.setAltText(altText);
    }
}
