/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.jpa;

import com.imcode.imcms.addon.imagearchive.entity.Keyword;
import com.imcode.imcms.addon.imagearchive.repository.KeywordsRepository;
import com.imcode.imcms.addon.imagearchive.service.KeywordService;
import com.imcode.imcms.addon.imagearchive.service.exception.KeywordExistsException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class KeywordServiceImpl
implements KeywordService {
    @Autowired
    private KeywordsRepository keywordsRepository;

    @Override
    public Keyword createKeyword(String newKeywordName) throws KeywordExistsException {
        if (this.existsKeyword(newKeywordName)) {
            throw new KeywordExistsException();
        }
        Keyword keyword = new Keyword();
        keyword.setName(newKeywordName);
        this.keywordsRepository.save(keyword);
        return keyword;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Keyword> getKeywords() {
        List keywords = this.keywordsRepository.findAll();
        return keywords;
    }

    @Override
    @Transactional
    public void deleteKeyword(Long keywordId) {
        if (!this.keywordsRepository.exists(keywordId)) {
            return;
        }
        Keyword keyword = (Keyword)this.keywordsRepository.getOne(keywordId);
        keyword.getImages().clear();
        this.keywordsRepository.save(keyword);
        this.keywordsRepository.delete(keywordId);
        this.keywordsRepository.flush();
    }

    @Override
    public void updateKeyword(Long keywordId, String keywordName) throws KeywordExistsException {
        Keyword keyword = (Keyword)this.keywordsRepository.findOne(keywordId);
        if (keyword != null) {
            keyword.setName(keywordName);
            this.keywordsRepository.save(keyword);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean existsKeyword(String newKeywordName) {
        return this.keywordsRepository.findByName(newKeywordName) != null;
    }

    @Override
    public List<Keyword> findKeywordsByNameLike(String text) {
        return this.keywordsRepository.findByNameLike(text);
    }
}

