/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.command.SaveRoleCategoriesCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.CategoryRoles;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.repository.CategoryRolesRepository;
import com.imcode.imcms.addon.imagearchive.repository.RoleRepository;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.RoleService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RoleServiceImpl
implements RoleService {
    private static final Log log = LogFactory.getLog(RoleService.class);
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private CategoryRolesRepository categoryRolesRepository;
    @Autowired
    private Facade facade;

    @Override
    public List<Role> getRolesByCategoryId(int id) {
        List<CategoryRoles> categoryRolesList = this.categoryRolesRepository.findByCategoryId(id);
        ArrayList<Role> rolesResult = new ArrayList<Role>();
        for (CategoryRoles categoryRoles : categoryRolesList) {
            rolesResult.add(categoryRoles.getRole());
        }
        return rolesResult;
    }

    @Override
    public List<Category> getUsableRoleCategories(Role role) {
        return this.getRoleCategories(role.getId(), true, false);
    }

    @Override
    public List<Category> getUsableRoleCategories(Role ... roles) {
        HashSet<Category> result = new HashSet<Category>();
        for (Role role : roles) {
            result.addAll(this.getRoleCategories(role.getId(), true, false));
        }
        return new ArrayList<Category>(result);
    }

    @Override
    public List<Category> getUsableRoleCategories(int id) {
        return this.getRoleCategories(id, true, false);
    }

    @Override
    public List<Category> getUsableRoleCategories(int ... ids) {
        HashSet<Category> result = new HashSet<Category>();
        for (int id : ids) {
            result.addAll(this.getRoleCategories(id, true, false));
        }
        return new ArrayList<Category>(result);
    }

    @Override
    public List<Category> getChangeableRoleCategories(int id) {
        return this.getRoleCategories(id, false, true);
    }

    @Override
    public List<Category> getChangeableRoleCategories(int ... ids) {
        HashSet<Category> result = new HashSet<Category>();
        for (int id : ids) {
            result.addAll(this.getRoleCategories(id, false, true));
        }
        return new ArrayList<Category>(result);
    }

    @Override
    public List<Category> getChangeableRoleCategories(Role role) {
        return this.getRoleCategories(role.getId(), false, true);
    }

    @Override
    public List<Category> getChangeableRoleCategories(Role ... roles) {
        HashSet<Category> result = new HashSet<Category>();
        for (Role role : roles) {
            result.addAll(this.getRoleCategories(role.getId(), false, true));
        }
        return new ArrayList<Category>(result);
    }

    @Override
    public List<Category> getAllRoleCategories(int id) {
        return this.getRoleCategories(id, false, false);
    }

    private List<Category> getRoleCategories(int id, boolean needUsable, boolean needChangable) {
        HashSet<Category> categoriesResult = new HashSet<Category>();
        List<CategoryRoles> categoryRolesList = this.categoryRolesRepository.findByRoleId(id);
        for (CategoryRoles categoryRoles : categoryRolesList) {
            if (needUsable && !categoryRoles.getCanUse().booleanValue() || needChangable && !categoryRoles.getCanChange().booleanValue()) continue;
            categoriesResult.add(this.facade.getCategoryService().getCategory(categoryRoles.getCategoryId()));
        }
        return new ArrayList<Category>(categoriesResult);
    }

    @Override
    public Role getRoleById(int roleId) {
        return (Role)this.roleRepository.findOne(Integer.valueOf(roleId));
    }

    @Override
    public Role getRoleByName(String name) {
        return this.roleRepository.findByName(name);
    }

    @Override
    public List<Role> getAllRoles() {
        return this.roleRepository.findAll();
    }

    @Override
    public List<CategoryRoles> getCategoryRolesByRole(Role role) {
        return this.categoryRolesRepository.findByRoleId(role.getId());
    }

    @Override
    public void assignCategoryRoles(Role role, List<SaveRoleCategoriesCommand.CategoryRight> categoryRights) {
        List<CategoryRoles> toDelete = this.categoryRolesRepository.findByRoleId(role.getId());
        for (CategoryRoles categoryRole : toDelete) {
            this.categoryRolesRepository.delete(categoryRole);
        }
        this.categoryRolesRepository.flush();
        if (categoryRights != null) {
            for (SaveRoleCategoriesCommand.CategoryRight categoryRight : categoryRights) {
                CategoryRoles cr = new CategoryRoles(categoryRight.getCategoryId(), role.getId(), categoryRight.isCanUse(), categoryRight.isCanEditOrAdd());
                this.categoryRolesRepository.save(cr);
            }
        }
        this.categoryRolesRepository.flush();
    }
}

