/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AccessFilter
implements Filter {
    private static final Log log = LogFactory.getLog(AccessFilter.class);
    private FilterConfig filterConfig = null;
    private Facade facade;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.filterConfig = filterConfig;
        this.facade = (Facade)context.getBean(Facade.class);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.fixUTF8(request, response);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.setLocale(httpRequest, httpResponse);
        this.setRequestUrl(httpRequest);
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    private void setLocale(HttpServletRequest request, HttpServletResponse response) {
        Utils.setLocale(request, this.facade.getConfig().getLanguages());
    }

    private void setRequestUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            url = url + "?" + queryString;
        }
        request.setAttribute("requestUrl", (Object)url);
    }

    private void fixUTF8(ServletRequest request, ServletResponse response) throws IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
    }

    public void destroy() {
    }
}

