/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class SearchImageCommand
implements Serializable {
    public static final short SHOW_ALL = 0;
    public static final short SHOW_NEW = 1;
    public static final short SHOW_ERASED = 2;
    public static final short SHOW_WITH_VALID_LICENCE = 3;
    public static final List<Integer> CATEGORY_ALL = Arrays.asList(-1);
    public static final List<Integer> CATEGORY_NO_CATEGORY = Arrays.asList(-2);
    public static final long KEYWORD_ALL = -1L;
    public static final short SORT_BY_ARTIST = 0;
    public static final short SORT_BY_ALPHABET = 1;
    public static final short SORT_BY_ENTRY_DATE = 2;
    public static final short SORT_ASCENDING = 0;
    public static final short SORT_DESCENDING = 1;
    public static final int DEFAULT_PAGE_SIZE = 10;
    private static final long serialVersionUID = 844191223450843364L;
    private short show = 0;
    private List<Integer> categoryIds = CATEGORY_ALL;
    private long keywordId = -1L;
    private String freetext;
    private String artist;
    private String licenseDt;
    private String licenseEndDt;
    private String activeDt;
    private String activeEndDt;
    private int resultsPerPage = 10;
    private short sortBy = (short)2;
    private short sortOrder = 1;
    private String clearAction;
    private Date licenseDate;
    private Date licenseEndDate;
    private Date activeDate;
    private Date activeEndDate;
    private boolean fileNamesOnly;
    private boolean isUnfolded;

    public void copyFrom(SearchImageCommand command) {
        this.show = command.getShow();
        this.categoryIds = command.getCategoryIds();
        this.keywordId = command.getKeywordId();
        this.freetext = command.getFreetext();
        this.artist = command.getArtist();
        this.licenseDt = command.getLicenseDt();
        this.licenseEndDt = command.getLicenseEndDt();
        this.activeDt = command.getActiveDt();
        this.activeEndDt = command.getActiveEndDt();
        this.resultsPerPage = command.getResultsPerPage();
        this.sortBy = command.getSortBy();
        this.sortOrder = command.getSortOrder();
        this.licenseDate = command.getLicenseDate();
        this.licenseEndDate = command.getLicenseEndDate();
        this.activeDate = command.getActiveDate();
        this.activeEndDate = command.getActiveEndDate();
        this.fileNamesOnly = command.isFileNamesOnly();
        this.isUnfolded = command.isUnfolded();
    }

    public void copyFrom(Map<String, Object> command) {
        this.show = Short.parseShort(ObjectUtils.toString((Object)command.get("show"), (String)"0"));
        this.categoryIds = (List)command.get("categoryIds");
        this.keywordId = Long.parseLong(ObjectUtils.toString((Object)command.get("keywordId"), (String)"-1"));
        this.freetext = (String)command.get("freetext");
        this.artist = (String)command.get("artist");
        this.licenseDt = (String)command.get("licenseDt");
        this.licenseEndDt = (String)command.get("licenseEndDt");
        this.activeDt = (String)command.get("activeDt");
        this.activeEndDt = (String)command.get("activeEndDt");
        this.resultsPerPage = Integer.parseInt(ObjectUtils.toString((Object)command.get("resultsPerPage"), (String)"10"));
        this.sortBy = Short.parseShort(ObjectUtils.toString((Object)command.get("sortBy"), (String)"2"));
        this.sortOrder = Short.parseShort(ObjectUtils.toString((Object)command.get("sortOrder"), (String)"1"));
        DateFormat dateParser = SimpleDateFormat.getDateTimeInstance();
        try {
            this.licenseDate = dateParser.parse(ObjectUtils.toString((Object)command.get("licenseDate"), (String)""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.licenseEndDate = dateParser.parse(ObjectUtils.toString((Object)command.get("licenseEndDate"), (String)""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.activeDate = dateParser.parse(ObjectUtils.toString((Object)command.get("activeDate"), (String)""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.activeEndDate = dateParser.parse(ObjectUtils.toString((Object)command.get("activeEndDate"), (String)""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fileNamesOnly = Boolean.parseBoolean(ObjectUtils.toString((Object)command.get("fileNamesOnly"), (String)"false"));
        this.isUnfolded = Boolean.parseBoolean(ObjectUtils.toString((Object)command.get("unfolded"), (String)"false"));
    }

    @JsonIgnore
    public boolean isClear() {
        return this.clearAction != null;
    }

    public String getActiveDt() {
        return this.activeDt;
    }

    public void setActiveDt(String activeDt) {
        this.activeDt = activeDt;
    }

    public String getActiveEndDt() {
        return this.activeEndDt;
    }

    public void setActiveEndDt(String activeEndDt) {
        this.activeEndDt = activeEndDt;
    }

    public String getFreetext() {
        return this.freetext;
    }

    public void setFreetext(String freetext) {
        this.freetext = freetext;
    }

    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    public void setResultsPerPage(int resultsPerPage) {
        this.resultsPerPage = resultsPerPage;
    }

    public short getShow() {
        return this.show;
    }

    public void setShow(short show) {
        this.show = show;
    }

    public short getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(short sortBy) {
        this.sortBy = sortBy;
    }

    public String getLicenseDt() {
        return this.licenseDt;
    }

    public void setLicenseDt(String licenseDt) {
        this.licenseDt = licenseDt;
    }

    public String getLicenseEndDt() {
        return this.licenseEndDt;
    }

    public void setLicenseEndDt(String licenseEndDt) {
        this.licenseEndDt = licenseEndDt;
    }

    public Date getActiveDate() {
        return this.activeDate;
    }

    public void setActiveDate(Date activeDate) {
        this.activeDate = activeDate;
    }

    public Date getActiveEndDate() {
        return this.activeEndDate;
    }

    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    public Date getLicenseDate() {
        return this.licenseDate;
    }

    public void setLicenseDate(Date licenseDate) {
        this.licenseDate = licenseDate;
    }

    public Date getLicenseEndDate() {
        return this.licenseEndDate;
    }

    public void setLicenseEndDate(Date licenseEndDate) {
        this.licenseEndDate = licenseEndDate;
    }

    public List<Integer> getCategoryIds() {
        return this.categoryIds;
    }

    public void setCategoryIds(List<Integer> categoryIds) {
        this.categoryIds = categoryIds;
    }

    public long getKeywordId() {
        return this.keywordId;
    }

    public void setKeywordId(long keywordId) {
        this.keywordId = keywordId;
    }

    public String getArtist() {
        return this.artist;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public String getClearAction() {
        return this.clearAction;
    }

    public void setClearAction(String clearAction) {
        this.clearAction = clearAction;
    }

    public boolean isFileNamesOnly() {
        return this.fileNamesOnly;
    }

    public void setFileNamesOnly(boolean fileNamesOnly) {
        this.fileNamesOnly = fileNamesOnly;
    }

    public boolean isUnfolded() {
        return this.isUnfolded;
    }

    public void setUnfolded(boolean unfolded) {
        this.isUnfolded = unfolded;
    }

    public short getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(short sortOrder) {
        this.sortOrder = sortOrder;
    }
}

