package com.imcode.imcms.addon.imagearchive.validator;

import com.imcode.imcms.addon.imagearchive.command.ChangeImageDataCommand;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.ValidatorUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

//import com.imcode.imcms.addon.imagearchive.entity.User;

public class ChangeImageDataValidator implements Validator {
    private Facade facade;
//    private User user;

    public ChangeImageDataValidator(Facade facade) {
        this.facade = facade;
    }

//    public ChangeImageDataValidator(Facade facade) {
//        this.facade = facade;
//        this.user = user;
//    }
    
    
    public boolean supports(Class clazz) {
        return ChangeImageDataCommand.class.isAssignableFrom(clazz);
    }
    
    public void validate(Object target, Errors errors) {
        ChangeImageDataCommand command = (ChangeImageDataCommand) target;
        
        ValidatorUtils.rejectValueIfLonger("imageNm", 255, "fieldLengthError", errors);
        ValidatorUtils.rejectValueIfLonger("description", 255, "fieldLengthError", errors);
        ValidatorUtils.rejectValueIfLonger("artist", 255, "fieldLengthError", errors);
        ValidatorUtils.rejectValueIfLonger("uploadedBy", 130, "fieldLengthError", errors);
        ValidatorUtils.rejectValueIfLonger("copyright", 255, "fieldLengthError", errors);

        List<Long> categoryIds = command.getCategoryIds();
//        if (!categoryIds.isEmpty()) {
//            errors.rejectValue("categories", "categoryPermissionError");
//        }

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

        String licenseDt = StringUtils.trimToNull(command.getLicenseDt());
        if (licenseDt != null) {
            try {
                command.setLicenseDate(df.parse(licenseDt));
            } catch (ParseException ex) {
                errors.rejectValue("licenseDt", "invalidStartDateError");
            }
        }

        String licenseEndDt = StringUtils.trimToNull(command.getLicenseEndDt());
        if (licenseEndDt != null) {
            try {
                command.setLicenseEndDate(df.parse(licenseEndDt));
            } catch (ParseException ex) {
                errors.rejectValue("licenseEndDt", "invalidEndDateError");
            }
        }

        if(command.getLicenseDate() != null && command.getLicenseEndDate() != null && (command.getLicenseDate().compareTo(command.getLicenseEndDate()) >= 1)) {
            errors.rejectValue("licenseDt", "invalidStartDateError");
            errors.rejectValue("licenseEndDt", "invalidEndDateError");
        }
    }
}
