package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class AccessFilter implements Filter {
    private static final Log log = LogFactory.getLog(AccessFilter.class);
    
    private FilterConfig filterConfig = null;
    private Facade facade;
    
    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext(filterConfig.getServletContext());
        this.filterConfig = filterConfig;
        this.facade = context.getBean(Facade.class);
    }
    
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        fixUTF8(request, response);

        HttpServletRequest httpRequest = (HttpServletRequest) request;
        HttpServletResponse httpResponse = (HttpServletResponse) response;

        setLocale(httpRequest, httpResponse);
        setRequestUrl(httpRequest);

        chain.doFilter(httpRequest, httpResponse);
    }
    
    private void setLocale(HttpServletRequest request, HttpServletResponse response) {
		Utils.setLocale(request, facade.getConfig().getLanguages());
    }
    
    private void setRequestUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        String queryString = request.getQueryString();
        
        if (queryString != null) {
            url += "?" + queryString;
        }
        
        request.setAttribute("requestUrl", url);
    }
    
    private void fixUTF8(ServletRequest request, ServletResponse response) throws IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
    }
    
    public void destroy() {
    }
}
