package com.imcode.imcms.addon.imagearchive.entity;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import java.io.Serializable;

@Embeddable
public class UserRolesPK implements Serializable {
    private static final long serialVersionUID = -8631078879444778631L;
    
    @Column(name="user_id", nullable=false)
    private int userId;
    @Column(name="role_id", nullable=false)
    private int roleId;

    
    public UserRolesPK() {
    }

    public UserRolesPK(int userId, int roleId) {
        this.userId = userId;
        this.roleId = roleId;
    }
    
    
    public int getRoleId() {
        return roleId;
    }

    public void setRoleId(int roleId) {
        this.roleId = roleId;
    }

    public int getUserId() {
        return userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    
    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final UserRolesPK other = (UserRolesPK) obj;
        if (this.userId != other.userId) {
            return false;
        }
        if (this.roleId != other.roleId) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + this.userId;
        hash = 67 * hash + this.roleId;
        
        return hash;
    }

    @Override
    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.UserRolesPK[userId: %d, roleId: %d]", userId, roleId);
    }
}
