package com.imcode.imcms.addon.imagearchive.service;

import com.imcode.imcms.addon.imagearchive.command.SearchImageCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Exif;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Keyword;
import com.imcode.imcms.addon.imagearchive.util.Pagination;
import com.imcode.imcms.addon.imagearchive.util.image.ImageInfo;

import java.io.File;
import java.util.List;

public interface ImageService {

    Image findById(final Long imageId);

    Image findById(final Long imageId, final List<Long> categoryIds);

    Exif findExifByPK(Long imageId);

    Image createImage(File tempFile, ImageInfo imageInfo, String imageName, short status);

    List<Image> createImagesFromZip(File tempFile);

    void createImages(List<Object[]> tuples);

    void deleteImage(Long imageId);

    void updateFullData(final Image image, final List<Long> categoryIds, final List<String> imageKeywords);

    void updateData(final Image image, final List<Long> categoryIds, final List<String> imageKeywords);

    void archiveImage(final Long imageId);

    void unarchiveImage(final Long imageId);

    List<Image> getAllImages();

    Long searchImagesCount(final List<Long> categoryIds);

    List<Image> searchImages(final Pagination pag, SearchImageCommand command);

    List<Image> searchImages(SearchImageCommand command);

    List<Category> findImageCategories(final Long imageId);

    List<Category> findAvailableImageCategories(final Long imageId);

    List<Keyword> findAvailableKeywords(final Long imageId);

    List<Keyword> findImageKeywords(final Long imageId);

    File uploadFile(byte[] data);

}
