/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Exif;
import com.imcode.imcms.addon.imagearchive.entity.Keyword;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="archive_images")
public class Image
implements Serializable {
    public static final short STATUS_UPLOADED = 0;
    public static final short STATUS_ACTIVE = 1;
    public static final short STATUS_ARCHIVED = 2;
    private static final long serialVersionUID = -1831641612874730366L;
    @Id
    @GeneratedValue
    private Long id;
    @Column(name="image_nm", length=255, nullable=false)
    private String name = "";
    @Column(name="format", nullable=false)
    private short format;
    @Column(name="width", nullable=false)
    private int width;
    @Column(name="height", nullable=false)
    private int height;
    @Column(name="file_size", nullable=false)
    private int fileSize;
    @Column(name="uploaded_by", length=130, nullable=false)
    private String uploadedBy = "";
    @Column(name="status", nullable=false)
    private short status = 0;
    @Column(name="created_dt", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDt = new Date();
    @Column(name="updated_dt", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date updatedDt = new Date();
    @Column(name="license_dt")
    @Temporal(value=TemporalType.DATE)
    private Date licenseDt;
    @Column(name="license_end_dt")
    @Temporal(value=TemporalType.DATE)
    private Date licenseEndDt;
    @Column(name="alt_text")
    private String altText;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="image_categories", joinColumns={@JoinColumn(name="image_id", nullable=false)}, inverseJoinColumns={@JoinColumn(name="category_id", nullable=false)})
    private List<Category> categories;
    @ManyToMany(cascade={CascadeType.ALL})
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @JoinTable(name="archive_image_keywords", joinColumns={@JoinColumn(name="image_id", nullable=false, insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="keyword_id", nullable=false, insertable=false, updatable=false)})
    private List<Keyword> keywords;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="exif_id")
    private Exif exif;
    @Transient
    private boolean canChange;

    public int getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreatedDt() {
        return this.createdDt;
    }

    public void setCreatedDt(Date createdDt) {
        this.createdDt = createdDt;
    }

    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public String getUploadedBy() {
        return this.uploadedBy;
    }

    public void setUploadedBy(String uploadedBy) {
        this.uploadedBy = uploadedBy;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public short getFormat() {
        return this.format;
    }

    public void setFormat(short format) {
        this.format = format;
    }

    public Date getLicenseDt() {
        return this.licenseDt;
    }

    public void setLicenseDt(Date licenseDt) {
        this.licenseDt = licenseDt;
    }

    public Date getLicenseEndDt() {
        return this.licenseEndDt;
    }

    public void setLicenseEndDt(Date licenseEndDt) {
        this.licenseEndDt = licenseEndDt;
    }

    public short getStatus() {
        return this.status;
    }

    public void setStatus(short status) {
        this.status = status;
    }

    public Date getUpdatedDt() {
        return this.updatedDt;
    }

    public void setUpdatedDt(Date updatedDt) {
        this.updatedDt = updatedDt;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public List<Keyword> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<Keyword> keywords) {
        this.keywords = keywords;
    }

    @JsonIgnore
    public boolean isArchived() {
        return this.status == 2;
    }

    public boolean isCanChange() {
        return this.canChange;
    }

    public void setCanChange(boolean canChange) {
        this.canChange = canChange;
    }

    public Exif getExif() {
        return this.exif;
    }

    public void setExif(Exif exif) {
        this.exif = exif;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Image other = (Image)obj;
        return this.id == other.id;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (int)(this.id ^ this.id >>> 32);
        return hash;
    }

    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.Images[id: %d, name: %s, uploadedBy: %s]", this.id, this.name, this.uploadedBy);
    }
}

