/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.entity;

import com.imcode.imcms.addon.imagearchive.entity.CategoryType;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="categories")
public class Category
implements Serializable,
Comparable<Category> {
    private static final long serialVersionUID = 7533187253952781894L;
    @Id
    @Column(name="category_id", nullable=false)
    @GeneratedValue
    private Long id;
    @Column(name="name", length=128, nullable=false)
    private String name;
    @Column(name="description", length=500)
    private String description;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="image_categories", inverseJoinColumns={@JoinColumn(name="image_id", nullable=false)}, joinColumns={@JoinColumn(name="category_id", nullable=false)})
    private List<Image> images;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="category_type_id", referencedColumnName="category_type_id")
    private CategoryType type;

    public Category() {
    }

    public Category(String name, CategoryType categoryType) {
        this.name = name;
        this.type = categoryType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CategoryType getType() {
        return this.type;
    }

    public void setType(CategoryType type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        int hash = 7;
        hash = (int)((long)(97 * hash) + this.id);
        return hash;
    }

    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.Categories[id: %d, name: %s]", this.id, this.name);
    }

    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    @Override
    public int compareTo(Category o) {
        return this.id.compareTo(o.getId());
    }
}

