/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.imcms.addon.imagearchive.entity.Exif;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class ChangeImageDataCommand
implements Serializable {
    private static final long serialVersionUID = 7628469804368247486L;
    @Autowired
    private Facade facade;
    private String imageNm;
    private String description;
    private String categories;
    private String keywords;
    private String imageKeywords;
    private String artist;
    private String uploadedBy;
    private String copyright;
    private String licenseDt;
    private String licenseEndDt;
    private boolean changedFile;
    private int rotation = 0;
    @JsonIgnore
    private CommonsMultipartFile file;
    private Date licenseDate;
    private Date licenseEndDate;
    private String altText;
    private List<Long> categoryIds = new ArrayList<Long>();
    private List<String> keywordNames = new ArrayList<String>();
    private List<String> imageKeywordNames = new ArrayList<String>();
    private boolean submitted;
    private boolean overrideDesc;
    private boolean overrideArtist;
    private boolean overrideCopyright;

    public void fromImage(Image image) {
        Exif exif = image.getExif();
        this.artist = exif.getArtist();
        this.copyright = exif.getCopyright();
        this.description = exif.getDescription();
        this.imageNm = image.getName();
        this.uploadedBy = image.getUploadedBy();
        this.altText = image.getAltText();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (image.getLicenseDt() != null) {
            this.licenseDt = df.format(image.getLicenseDt());
        }
        if (image.getLicenseEndDt() != null) {
            this.licenseEndDt = df.format(image.getLicenseEndDt());
        }
    }

    public void toImage(Image image) {
        String newDescription = StringUtils.trimToEmpty((String)this.description);
        String newArtist = StringUtils.trimToEmpty((String)this.artist);
        String newCopyright = StringUtils.trimToEmpty((String)this.copyright);
        Exif exif = image.getExif();
        if (!newDescription.isEmpty() && (!this.isOverrideDesc() || this.isOverrideDesc() && StringUtils.isEmpty((CharSequence)exif.getDescription()))) {
            exif.setDescription(newDescription);
        }
        if (!newArtist.isEmpty() && (!this.isOverrideArtist() || this.isOverrideArtist() && StringUtils.isEmpty((CharSequence)exif.getArtist()))) {
            exif.setArtist(newArtist);
        }
        if (!this.isOverrideCopyright() || this.isOverrideCopyright() && StringUtils.isEmpty((CharSequence)exif.getCopyright())) {
            exif.setCopyright(newCopyright);
        }
        image.setName(StringUtils.trimToEmpty((String)this.imageNm));
        image.setUploadedBy(StringUtils.trimToEmpty((String)this.uploadedBy));
        image.setLicenseDt(this.licenseDate);
        image.setLicenseEndDt(this.licenseEndDate);
        image.setAltText(this.altText);
    }

    public String getArtist() {
        return this.artist;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImageNm() {
        return this.imageNm;
    }

    public void setImageNm(String imageNm) {
        this.imageNm = imageNm;
    }

    public String getLicenseDt() {
        return this.licenseDt;
    }

    public void setLicenseDt(String licenseDt) {
        this.licenseDt = licenseDt;
    }

    public String getLicenseEndDt() {
        return this.licenseEndDt;
    }

    public void setLicenseEndDt(String licenseEndDt) {
        this.licenseEndDt = licenseEndDt;
    }

    public String getUploadedBy() {
        return this.uploadedBy;
    }

    public void setUploadedBy(String uploadedBy) {
        this.uploadedBy = uploadedBy;
    }

    public Date getLicenseDate() {
        return this.licenseDate;
    }

    public void setLicenseDate(Date licenseDate) {
        this.licenseDate = licenseDate;
    }

    public Date getLicenseEndDate() {
        return this.licenseEndDate;
    }

    public void setLicenseEndDate(Date licenseEndDate) {
        this.licenseEndDate = licenseEndDate;
    }

    public String getCategories() {
        return this.categories;
    }

    public void setCategories(String categories) {
        if (categories != null) {
            String[] parts = categories.split(",");
            this.categoryIds = new ArrayList<Long>(parts.length);
            for (String part : parts) {
                try {
                    this.categoryIds.add(Long.parseLong(part, 10));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.categories = categories;
    }

    public List<Long> getCategoryIds() {
        return this.categoryIds;
    }

    public String getImageKeywords() {
        return this.imageKeywords;
    }

    public void setImageKeywords(String imageKeywords) {
        this.imageKeywordNames.clear();
        imageKeywords = StringUtils.trimToNull((String)imageKeywords);
        if (imageKeywords != null) {
            String[] parts;
            for (String part : parts = imageKeywords.split("/")) {
                try {
                    part = URLDecoder.decode(part, "UTF-8").trim();
                    if (StringUtils.isEmpty((CharSequence)part)) continue;
                    this.imageKeywordNames.add(StringUtils.substring((String)part.toLowerCase(), (int)0, (int)50));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        this.imageKeywords = imageKeywords;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywordNames.clear();
        StringUtils.trimToNull((String)keywords);
        if (keywords != null) {
            String[] parts;
            for (String part : parts = keywords.split("/")) {
                try {
                    part = URLDecoder.decode(part, "UTF-8").trim();
                    if (StringUtils.isEmpty((CharSequence)part)) continue;
                    this.keywordNames.add(StringUtils.substring((String)part.toLowerCase(), (int)0, (int)50));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        this.keywords = keywords;
    }

    public List<String> getImageKeywordNames() {
        return this.imageKeywordNames;
    }

    public List<String> getKeywordNames() {
        return this.keywordNames;
    }

    public boolean isChangedFile() {
        return this.changedFile;
    }

    public void setChangedFile(boolean changedFile) {
        this.changedFile = changedFile;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public CommonsMultipartFile getFile() {
        return this.file;
    }

    public void setFile(CommonsMultipartFile file) {
        this.file = file;
    }

    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public boolean isOverrideDesc() {
        return this.overrideDesc;
    }

    public void setOverrideDesc(boolean overrideDesc) {
        this.overrideDesc = overrideDesc;
    }

    public boolean isOverrideArtist() {
        return this.overrideArtist;
    }

    public void setOverrideArtist(boolean overrideArtist) {
        this.overrideArtist = overrideArtist;
    }

    public boolean isOverrideCopyright() {
        return this.overrideCopyright;
    }

    public void setOverrideCopyright(boolean overrideCopyright) {
        this.overrideCopyright = overrideCopyright;
    }
}

