package com.imcode.imcms.addon.imagearchive.service;

import com.imcode.imcms.addon.imagearchive.Config;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class Facade {
    @Autowired
    private Config config;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ImcmsImageService imcmsImageService;
    @Autowired
    private MessageSource messageSource;

    @Autowired
    @Qualifier("remoteFileService")
    private FileService fileService;

    @Autowired
    @Qualifier("remoteImageService")
    private ImageService imageService;

    @Autowired
    @Qualifier("remoteLibraryService")
    private LibraryService libraryService;

    @Autowired
    @Qualifier("remoteCategoryService")
    private CategoryService categoryService;

    @Autowired
    @Qualifier("remoteKeywordService")
    private KeywordService keywordService;


    public Facade() {
    }


    public Config getConfig() {
        return config;
    }

    public FileService getFileService() {
        return fileService;
    }

    public ImageService getImageService() {
        return imageService;
    }

    public LibraryService getLibraryService() {
        return libraryService;
    }

    public CategoryService getCategoryService() {
        return categoryService;
    }

    public KeywordService getKeywordService() {
        return keywordService;
    }

    public RoleService getRoleService() {
        return roleService;
    }

    public UserService getUserService() {
        return userService;
    }

    public ImcmsImageService getImcmsImageService() {
        return imcmsImageService;
    }

    public MessageSource getMessageSource() {
        return messageSource;
    }
}
