package com.imcode.imcms.addon.imagearchive.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.imcms.addon.imagearchive.entity.Exif;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Keyword;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Component
public class ChangeImageDataCommand implements Serializable {
    private static final long serialVersionUID = 7628469804368247486L;

    @Autowired
    private Facade facade;

    private String imageNm;
    private String description;
    private String categories;
    private String keywords;
    private String imageKeywords;
    private String artist;
    private String uploadedBy;
    private String copyright;
    private String licenseDt;
    private String licenseEndDt;

    private boolean changedFile;
    private int rotation = 0;
    @JsonIgnore
    private CommonsMultipartFile file;

    private Date licenseDate;
    private Date licenseEndDate;
    private String altText;

    private List<Long> categoryIds = new ArrayList<Long>();
    private List<String> keywordNames = new ArrayList<String>();
    private List<String> imageKeywordNames = new ArrayList<String>();

    // just a flag that the data was submitted
    private boolean submitted;

    /* Override if empty */
    private boolean overrideDesc;
    private boolean overrideArtist;
    private boolean overrideCopyright;

    public ChangeImageDataCommand() {
    }


    public void fromImage(Image image) {
//        Exif exif = image.getChangedExif();
        Exif exif = image.getExif();

        this.artist = exif.getArtist();
        this.copyright = exif.getCopyright();
        this.description = exif.getDescription();
        this.imageNm = image.getName();
        this.uploadedBy = image.getUploadedBy();
        this.altText = image.getAltText();

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

        if (image.getLicenseDt() != null) {
            this.licenseDt = df.format(image.getLicenseDt());
        }

        if (image.getLicenseEndDt() != null) {
            this.licenseEndDt = df.format(image.getLicenseEndDt());
        }
    }

    public void toImage(Image image) {
        String newDescription = StringUtils.trimToEmpty(description);
        String newArtist = StringUtils.trimToEmpty(artist);
        String newCopyright = StringUtils.trimToEmpty(copyright);
        Exif exif = image.getExif();

        if (!newDescription.isEmpty() && (!isOverrideDesc() || isOverrideDesc() && StringUtils.isEmpty(exif.getDescription()))) {
            exif.setDescription(newDescription);
        }
        if (!newArtist.isEmpty() && (!isOverrideArtist() || isOverrideArtist() && StringUtils.isEmpty(exif.getArtist()))) {
            exif.setArtist(newArtist);
        }
        if (!isOverrideCopyright() || isOverrideCopyright() && StringUtils.isEmpty(exif.getCopyright())) {
            exif.setCopyright(newCopyright);
        }

        image.setName(StringUtils.trimToEmpty(imageNm));
        image.setUploadedBy(StringUtils.trimToEmpty(uploadedBy));
        image.setLicenseDt(licenseDate);
        image.setLicenseEndDt(licenseEndDate);
        image.setAltText(altText);
    }

    public String getArtist() {
        return artist;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public String getCopyright() {
        return copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImageNm() {
        return imageNm;
    }

    public void setImageNm(String imageNm) {
        this.imageNm = imageNm;
    }

    public String getLicenseDt() {
        return licenseDt;
    }

    public void setLicenseDt(String licenseDt) {
        this.licenseDt = licenseDt;
    }

    public String getLicenseEndDt() {
        return licenseEndDt;
    }

    public void setLicenseEndDt(String licenseEndDt) {
        this.licenseEndDt = licenseEndDt;
    }

    public String getUploadedBy() {
        return uploadedBy;
    }

    public void setUploadedBy(String uploadedBy) {
        this.uploadedBy = uploadedBy;
    }

    public Date getLicenseDate() {
        return licenseDate;
    }

    public void setLicenseDate(Date licenseDate) {
        this.licenseDate = licenseDate;
    }

    public Date getLicenseEndDate() {
        return licenseEndDate;
    }

    public void setLicenseEndDate(Date licenseEndDate) {
        this.licenseEndDate = licenseEndDate;
    }

    public String getCategories() {
        return categories;
    }

    public void setCategories(String categories) {
        if (categories != null) {
            String[] parts = categories.split(",");
            categoryIds = new ArrayList<Long>(parts.length);

            for (String part : parts) {
                try {
                    categoryIds.add(Long.parseLong(part, 10));
                } catch (NumberFormatException ex) {
                }
            }
        }

        this.categories = categories;
    }

    public List<Long> getCategoryIds() {
        return categoryIds;
    }

    public String getImageKeywords() {
        return imageKeywords;
    }

    public void setImageKeywords(String imageKeywords) {
        imageKeywordNames.clear();
        imageKeywords = StringUtils.trimToNull(imageKeywords);
        if (imageKeywords != null) {
            String[] parts = imageKeywords.split("/");

            for (String part : parts) {
                try {
                    part = URLDecoder.decode(part, "UTF-8").trim();

                    if (!StringUtils.isEmpty(part)) {
                        imageKeywordNames.add(StringUtils.substring(part.toLowerCase(), 0, 50));
                    }
                } catch (UnsupportedEncodingException ex) {
                }
            }
        }

        this.imageKeywords = imageKeywords;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        keywordNames.clear();
        StringUtils.trimToNull(keywords);
        if (keywords != null) {
            String[] parts = keywords.split("/");

            for (String part : parts) {
                try {
                    part = URLDecoder.decode(part, "UTF-8").trim();

                    if (!StringUtils.isEmpty(part)) {
                        keywordNames.add(StringUtils.substring(part.toLowerCase(), 0, 50));
                    }
                } catch (UnsupportedEncodingException ex) {
                }
            }
        }

        this.keywords = keywords;
    }

    public List<String> getImageKeywordNames() {
        return imageKeywordNames;
    }

    public List<String> getKeywordNames() {
        return keywordNames;
    }

    public boolean isChangedFile() {
        return changedFile;
    }

    public void setChangedFile(boolean changedFile) {
        this.changedFile = changedFile;
    }

    public int getRotation() {
        return rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public CommonsMultipartFile getFile() {
        return file;
    }

    public void setFile(CommonsMultipartFile file) {
        this.file = file;
    }

    public String getAltText() {
        return altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public boolean isSubmitted() {
        return submitted;
    }

    public void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public boolean isOverrideDesc() {
        return overrideDesc;
    }

    public void setOverrideDesc(boolean overrideDesc) {
        this.overrideDesc = overrideDesc;
    }

    public boolean isOverrideArtist() {
        return overrideArtist;
    }

    public void setOverrideArtist(boolean overrideArtist) {
        this.overrideArtist = overrideArtist;
    }

    public boolean isOverrideCopyright() {
        return overrideCopyright;
    }

    public void setOverrideCopyright(boolean overrideCopyright) {
        this.overrideCopyright = overrideCopyright;
    }
}
