package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.ImcmsImageService;
import com.imcode.imcms.addon.imagearchive.service.RoleService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;

@Service
@Transactional
public class ImcmsImageServiceImpl implements ImcmsImageService {
    private static final Log log = LogFactory.getLog(RoleService.class);
    @Autowired
    private Facade facade;

    public String storeImage(byte[] imageInBytes, long imageId) {
        String filename = String.format("archive_img%d.jpg", imageId);

        File imcmsFile = new File(facade.getConfig().getImcmsImagesPath(), filename);

        try {
            FileUtils.writeByteArrayToFile(imcmsFile, imageInBytes);
        } catch (Exception ex) {
            log.warn(ex.getMessage(), ex);
            imcmsFile.delete();
            return null;
        }
        return filename;
    }
}
