/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.entity;

import com.imcode.imcms.addon.imagearchive.entity.CategoryRoles;
import java.io.Serializable;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="roles")
public class Role
implements Serializable {
    private static final long serialVersionUID = -9207677278215773638L;
    public static final int SUPERADMIN_ID = 0;
    public static final int USERADMIN_ID = 1;
    public static final int USERS_ID = 2;
    public static final int PERMISSION_USE_IMAGE = 0x400000;
    public static final int PERMISSION_CHANGE_IMAGE = 0x800000;
    public static final int[] ALL_PERMISSIONS = new int[]{0x400000, 0x800000};
    @Id
    @Column(name="role_id", nullable=false)
    @GeneratedValue
    private int id;
    @Column(name="role_name", length=60, nullable=false, unique=true)
    private String name;
    @Column(name="permissions", nullable=false)
    private int permissions;
    @Column(name="admin_role", nullable=false)
    private int adminRole;
    @OneToMany(fetch=FetchType.EAGER)
    @JoinColumn(name="role_id", referencedColumnName="role_id", insertable=false, updatable=false)
    private Set<CategoryRoles> categoryRoles;

    public Role() {
    }

    public Role(int id) {
        this.id = id;
    }

    public boolean isSuperadmin() {
        return this.id == 0;
    }

    public boolean isCanUseImage() {
        return (this.permissions & 0x400000) == 0x400000;
    }

    public boolean isCanChangeImage() {
        return (this.permissions & 0x800000) == 0x800000;
    }

    public int getAdminRole() {
        return this.adminRole;
    }

    public void setAdminRole(int adminRole) {
        this.adminRole = adminRole;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public void setPermissions(int permissions) {
        this.permissions = permissions;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<CategoryRoles> getCategoryRoles() {
        return this.categoryRoles;
    }

    public void setCategoryRoles(Set<CategoryRoles> categoryRoles) {
        this.categoryRoles = categoryRoles;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)obj;
        return this.id == other.id;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.id;
        return hash;
    }

    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.Role[id: %d, name: %s, permissions: %d]", this.id, this.name, this.permissions);
    }
}

